/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client;

import conductor.org.elasticsearch.client.Request;
import conductor.org.elasticsearch.client.RequestConverters;
import conductor.org.elasticsearch.client.security.ChangePasswordRequest;
import conductor.org.elasticsearch.client.security.DeleteRoleMappingRequest;
import conductor.org.elasticsearch.client.security.DeleteRoleRequest;
import conductor.org.elasticsearch.client.security.DisableUserRequest;
import conductor.org.elasticsearch.client.security.EnableUserRequest;
import conductor.org.elasticsearch.client.security.PutRoleMappingRequest;
import conductor.org.elasticsearch.client.security.PutUserRequest;
import conductor.org.elasticsearch.client.security.SetUserEnabledRequest;
import java.io.IOException;

final class SecurityRequestConverters {
    private SecurityRequestConverters() {
    }

    static Request changePassword(ChangePasswordRequest changePasswordRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack/security/user").addPathPart(changePasswordRequest.getUsername()).addPathPartAsIs("_password").build();
        Request request = new Request("POST", endpoint);
        request.setEntity(RequestConverters.createEntity(changePasswordRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withRefreshPolicy(changePasswordRequest.getRefreshPolicy());
        return request;
    }

    static Request putUser(PutUserRequest putUserRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack/security/user").addPathPart(putUserRequest.getUsername()).build();
        Request request = new Request("PUT", endpoint);
        request.setEntity(RequestConverters.createEntity(putUserRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withRefreshPolicy(putUserRequest.getRefreshPolicy());
        return request;
    }

    static Request putRoleMapping(PutRoleMappingRequest putRoleMappingRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack/security/role_mapping").addPathPart(putRoleMappingRequest.getName()).build();
        Request request = new Request("PUT", endpoint);
        request.setEntity(RequestConverters.createEntity(putRoleMappingRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withRefreshPolicy(putRoleMappingRequest.getRefreshPolicy());
        return request;
    }

    static Request enableUser(EnableUserRequest enableUserRequest) {
        return SecurityRequestConverters.setUserEnabled(enableUserRequest);
    }

    static Request disableUser(DisableUserRequest disableUserRequest) {
        return SecurityRequestConverters.setUserEnabled(disableUserRequest);
    }

    private static Request setUserEnabled(SetUserEnabledRequest setUserEnabledRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack/security/user").addPathPart(setUserEnabledRequest.getUsername()).addPathPart(setUserEnabledRequest.isEnabled() ? "_enable" : "_disable").build();
        Request request = new Request("PUT", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withRefreshPolicy(setUserEnabledRequest.getRefreshPolicy());
        return request;
    }

    static Request deleteRoleMapping(DeleteRoleMappingRequest deleteRoleMappingRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack/security/role_mapping").addPathPart(deleteRoleMappingRequest.getName()).build();
        Request request = new Request("DELETE", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withRefreshPolicy(deleteRoleMappingRequest.getRefreshPolicy());
        return request;
    }

    static Request deleteRole(DeleteRoleRequest deleteRoleRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack/security/role").addPathPart(deleteRoleRequest.getName()).build();
        Request request = new Request("DELETE", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withRefreshPolicy(deleteRoleRequest.getRefreshPolicy());
        return request;
    }
}

