/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.lucene;

import conductor.org.apache.logging.log4j.Logger;
import conductor.org.apache.lucene.util.InfoStream;
import conductor.org.elasticsearch.common.logging.Loggers;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class LoggerInfoStream
extends InfoStream {
    private final Logger parentLogger;
    private final Map<String, Logger> loggers = new ConcurrentHashMap<String, Logger>();

    public LoggerInfoStream(Logger parentLogger) {
        this.parentLogger = parentLogger;
    }

    @Override
    public void message(String component, String message) {
        this.getLogger(component).trace("{} {}: {}", (Object)Thread.currentThread().getName(), (Object)component, (Object)message);
    }

    @Override
    public boolean isEnabled(String component) {
        return this.getLogger(component).isTraceEnabled() && !component.equals("TP");
    }

    private Logger getLogger(String component) {
        return this.loggers.computeIfAbsent(component, c -> Loggers.getLogger(this.parentLogger, "." + c));
    }

    @Override
    public void close() {
    }
}

