/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.shard;

import conductor.org.apache.lucene.index.DirectoryReader;
import conductor.org.apache.lucene.index.LeafReader;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import conductor.org.elasticsearch.common.lucene.index.ElasticsearchLeafReader;
import conductor.org.elasticsearch.index.shard.ShardId;

public final class ShardUtils {
    private ShardUtils() {
    }

    @Nullable
    public static ShardId extractShardId(LeafReader reader) {
        ElasticsearchLeafReader esReader = ElasticsearchLeafReader.getElasticsearchLeafReader(reader);
        if (esReader != null) {
            assert (reader.getRefCount() > 0) : "ElasticsearchLeafReader is already closed";
            return esReader.shardId();
        }
        return null;
    }

    @Nullable
    public static ShardId extractShardId(DirectoryReader reader) {
        ElasticsearchDirectoryReader esReader = ElasticsearchDirectoryReader.getElasticsearchDirectoryReader(reader);
        if (esReader != null) {
            return esReader.shardId();
        }
        throw new IllegalArgumentException("can't extract shard ID, can't unwrap ElasticsearchDirectoryReader");
    }
}

