/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.similarity;

import conductor.org.apache.lucene.index.FieldInvertState;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.NumericDocValues;
import conductor.org.apache.lucene.search.CollectionStatistics;
import conductor.org.apache.lucene.search.Explanation;
import conductor.org.apache.lucene.search.TermStatistics;
import conductor.org.apache.lucene.search.similarities.Similarity;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.SmallFloat;
import conductor.org.elasticsearch.script.SimilarityScript;
import conductor.org.elasticsearch.script.SimilarityWeightScript;
import java.io.IOException;

public final class ScriptedSimilarity
extends Similarity {
    final String weightScriptSource;
    final String scriptSource;
    final SimilarityWeightScript.Factory weightScriptFactory;
    final SimilarityScript.Factory scriptFactory;
    final boolean discountOverlaps;

    public ScriptedSimilarity(String weightScriptString, SimilarityWeightScript.Factory weightScriptFactory, String scriptString, SimilarityScript.Factory scriptFactory, boolean discountOverlaps) {
        this.weightScriptSource = weightScriptString;
        this.weightScriptFactory = weightScriptFactory;
        this.scriptSource = scriptString;
        this.scriptFactory = scriptFactory;
        this.discountOverlaps = discountOverlaps;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(weightScript=[" + this.weightScriptSource + "], script=[" + this.scriptSource + "])";
    }

    @Override
    public long computeNorm(FieldInvertState state) {
        int numTerms = this.discountOverlaps ? state.getLength() - state.getNumOverlap() : state.getLength();
        return SmallFloat.intToByte4(numTerms);
    }

    @Override
    public Similarity.SimWeight computeWeight(float boost, CollectionStatistics collectionStats, TermStatistics ... termStats) {
        Query query = new Query(boost);
        long docCount = collectionStats.docCount();
        if (docCount == -1L) {
            docCount = collectionStats.maxDoc();
        }
        Field field = new Field(docCount, collectionStats.sumDocFreq(), collectionStats.sumTotalTermFreq());
        Term[] terms = new Term[termStats.length];
        for (int i = 0; i < termStats.length; ++i) {
            terms[i] = new Term(termStats[i].docFreq(), termStats[i].totalTermFreq());
        }
        return new Weight(collectionStats.field(), query, field, terms);
    }

    private double computeWeight(Query query, Field field, Term term) throws IOException {
        if (this.weightScriptFactory == null) {
            return 1.0;
        }
        SimilarityWeightScript weightScript = this.weightScriptFactory.newInstance();
        return weightScript.execute(query, field, term);
    }

    @Override
    public Similarity.SimScorer simScorer(Similarity.SimWeight w, LeafReaderContext context) throws IOException {
        final Weight weight = (Weight)w;
        final Similarity.SimScorer[] scorers = new Similarity.SimScorer[weight.terms.length];
        for (int i = 0; i < weight.terms.length; ++i) {
            final Term term = weight.terms[i];
            final SimilarityScript script = this.scriptFactory.newInstance();
            NumericDocValues norms = context.reader().getNormValues(weight.fieldName);
            final Doc doc = new Doc(norms);
            final double scoreWeight = this.computeWeight(weight.query, weight.field, term);
            scorers[i] = new Similarity.SimScorer(){

                @Override
                public float score(int docID, float freq) throws IOException {
                    doc.docID = docID;
                    doc.freq = freq;
                    return (float)script.execute(scoreWeight, weight.query, weight.field, term, doc);
                }

                @Override
                public float computeSlopFactor(int distance) {
                    return 1.0f / (float)(distance + 1);
                }

                @Override
                public float computePayloadFactor(int doc2, int start, int end, BytesRef payload) {
                    return 1.0f;
                }

                @Override
                public Explanation explain(int docID, Explanation freq) throws IOException {
                    doc.docID = docID;
                    float score = this.score(docID, freq.getValue());
                    return Explanation.match(score, "score from " + ScriptedSimilarity.this.toString() + " computed from:", Explanation.match((float)scoreWeight, "weight", new Explanation[0]), Explanation.match(weight.query.boost, "query.boost", new Explanation[0]), Explanation.match((float)weight.field.docCount, "field.docCount", new Explanation[0]), Explanation.match((float)weight.field.sumDocFreq, "field.sumDocFreq", new Explanation[0]), Explanation.match((float)weight.field.sumTotalTermFreq, "field.sumTotalTermFreq", new Explanation[0]), Explanation.match((float)term.docFreq, "term.docFreq", new Explanation[0]), Explanation.match((float)term.totalTermFreq, "term.totalTermFreq", new Explanation[0]), Explanation.match(freq.getValue(), "doc.freq", freq.getDetails()), Explanation.match((float)doc.getLength(), "doc.length", new Explanation[0]));
                }
            };
        }
        if (scorers.length == 1) {
            return scorers[0];
        }
        return new Similarity.SimScorer(){

            @Override
            public float score(int doc, float freq) throws IOException {
                double sum = 0.0;
                for (Similarity.SimScorer scorer : scorers) {
                    sum += (double)scorer.score(doc, freq);
                }
                return (float)sum;
            }

            @Override
            public float computeSlopFactor(int distance) {
                return 1.0f / (float)(distance + 1);
            }

            @Override
            public float computePayloadFactor(int doc, int start, int end, BytesRef payload) {
                return 1.0f;
            }

            @Override
            public Explanation explain(int doc, Explanation freq) throws IOException {
                Explanation[] subs = new Explanation[scorers.length];
                for (int i = 0; i < subs.length; ++i) {
                    subs[i] = scorers[i].explain(doc, freq);
                }
                return Explanation.match(this.score(doc, freq.getValue()), "Sum of:", subs);
            }
        };
    }

    public static class Doc {
        private final NumericDocValues norms;
        private int docID;
        private float freq;

        private Doc(NumericDocValues norms) {
            this.norms = norms;
        }

        public int getLength() throws IOException {
            if (this.norms == null) {
                return 1;
            }
            if (this.norms.advanceExact(this.docID)) {
                return SmallFloat.byte4ToInt((byte)this.norms.longValue());
            }
            return 0;
        }

        public float getFreq() {
            return this.freq;
        }
    }

    public static class Term {
        private final long docFreq;
        private final long totalTermFreq;

        private Term(long docFreq, long totalTermFreq) {
            this.docFreq = docFreq;
            this.totalTermFreq = totalTermFreq;
        }

        public long getDocFreq() {
            return this.docFreq;
        }

        public long getTotalTermFreq() {
            return this.totalTermFreq;
        }
    }

    public static class Field {
        private final long docCount;
        private final long sumDocFreq;
        private final long sumTotalTermFreq;

        private Field(long docCount, long sumDocFreq, long sumTotalTermFreq) {
            this.docCount = docCount;
            this.sumDocFreq = sumDocFreq;
            this.sumTotalTermFreq = sumTotalTermFreq;
        }

        public long getDocCount() {
            return this.docCount;
        }

        public long getSumDocFreq() {
            return this.sumDocFreq;
        }

        public long getSumTotalTermFreq() {
            return this.sumTotalTermFreq;
        }
    }

    public static class Query {
        private final float boost;

        private Query(float boost) {
            this.boost = boost;
        }

        public float getBoost() {
            return this.boost;
        }
    }

    private static class Weight
    extends Similarity.SimWeight {
        private final String fieldName;
        private final Query query;
        private final Field field;
        private final Term[] terms;

        Weight(String fieldName, Query query, Field field, Term[] terms) {
            this.fieldName = fieldName;
            this.query = query;
            this.field = field;
            this.terms = terms;
        }
    }
}

