/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.protocol.xpack.watcher;

import conductor.org.elasticsearch.action.ActionRequestValidationException;
import conductor.org.elasticsearch.action.ValidateActions;
import conductor.org.elasticsearch.action.support.master.MasterNodeRequest;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.unit.TimeValue;
import conductor.org.elasticsearch.protocol.xpack.watcher.PutWatchRequest;
import java.io.IOException;

public class DeleteWatchRequest
extends MasterNodeRequest<DeleteWatchRequest> {
    private static final TimeValue DEFAULT_TIMEOUT = TimeValue.timeValueSeconds(10L);
    private String id;
    private long version = -3L;

    public DeleteWatchRequest() {
        this((String)null);
    }

    public DeleteWatchRequest(String id) {
        this.id = id;
        this.masterNodeTimeout(DEFAULT_TIMEOUT);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.id == null) {
            validationException = ValidateActions.addValidationError("watch id is missing", validationException);
        } else if (!PutWatchRequest.isValidId(this.id)) {
            validationException = ValidateActions.addValidationError("watch id contains whitespace", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.id = in.readString();
        this.version = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
        out.writeLong(this.version);
    }

    public String toString() {
        return "delete [" + this.id + "]";
    }
}

