/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.script.mustache;

import conductor.org.elasticsearch.action.search.SearchRequest;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.RestChannel;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.action.RestStatusToXContentListener;
import conductor.org.elasticsearch.rest.action.search.RestSearchAction;
import conductor.org.elasticsearch.script.mustache.SearchTemplateAction;
import conductor.org.elasticsearch.script.mustache.SearchTemplateRequest;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;

public class RestSearchTemplateAction
extends BaseRestHandler {
    private static final Set<String> RESPONSE_PARAMS = Collections.singleton("typed_keys");

    public RestSearchTemplateAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_search/template", this);
        controller.registerHandler(RestRequest.Method.POST, "/_search/template", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_search/template", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_search/template", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_search/template", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_search/template", this);
    }

    @Override
    public String getName() {
        return "search_template_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        SearchTemplateRequest searchTemplateRequest;
        SearchRequest searchRequest = new SearchRequest();
        RestSearchAction.parseSearchRequest(searchRequest, request, null, size -> searchRequest.source().size(size));
        try (XContentParser parser = request.contentOrSourceParamParser();){
            searchTemplateRequest = SearchTemplateRequest.fromXContent(parser);
        }
        searchTemplateRequest.setRequest(searchRequest);
        return channel -> client.execute(SearchTemplateAction.INSTANCE, searchTemplateRequest, new RestStatusToXContentListener((RestChannel)channel));
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }
}

