/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.bucket.terms;

import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.search.DocValueFormat;
import conductor.org.elasticsearch.search.aggregations.Aggregation;
import conductor.org.elasticsearch.search.aggregations.BucketOrder;
import conductor.org.elasticsearch.search.aggregations.InternalAggregation;
import conductor.org.elasticsearch.search.aggregations.InternalAggregations;
import conductor.org.elasticsearch.search.aggregations.bucket.terms.InternalMappedTerms;
import conductor.org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import conductor.org.elasticsearch.search.aggregations.bucket.terms.LongTerms;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DoubleTerms
extends InternalMappedTerms<DoubleTerms, Bucket> {
    public static final String NAME = "dterms";

    public DoubleTerms(String name, BucketOrder order, int requiredSize, long minDocCount, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData, DocValueFormat format, int shardSize, boolean showTermDocCountError, long otherDocCount, List<Bucket> buckets, long docCountError) {
        super(name, order, requiredSize, minDocCount, pipelineAggregators, metaData, format, shardSize, showTermDocCountError, otherDocCount, buckets, docCountError);
    }

    public DoubleTerms(StreamInput in) throws IOException {
        super(in, Bucket::new);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public DoubleTerms create(List<Bucket> buckets) {
        return new DoubleTerms(this.name, this.order, this.requiredSize, this.minDocCount, this.pipelineAggregators(), (Map<String, Object>)this.metaData, this.format, this.shardSize, this.showTermDocCountError, this.otherDocCount, buckets, this.docCountError);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.term, prototype.docCount, aggregations, prototype.showDocCountError, prototype.docCountError, prototype.format);
    }

    @Override
    protected DoubleTerms create(String name, List<Bucket> buckets, long docCountError, long otherDocCount) {
        return new DoubleTerms(name, this.order, this.requiredSize, this.minDocCount, this.pipelineAggregators(), this.getMetaData(), this.format, this.shardSize, this.showTermDocCountError, otherDocCount, buckets, docCountError);
    }

    protected Bucket[] createBucketsArray(int size) {
        return new Bucket[size];
    }

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        boolean promoteToDouble = false;
        for (InternalAggregation agg : aggregations) {
            if (!(agg instanceof LongTerms) || ((LongTerms)agg).format != DocValueFormat.RAW) continue;
            promoteToDouble = true;
            break;
        }
        if (!promoteToDouble) {
            return super.doReduce(aggregations, reduceContext);
        }
        ArrayList<InternalAggregation> newAggs = new ArrayList<InternalAggregation>(aggregations.size());
        for (InternalAggregation agg : aggregations) {
            if (agg instanceof LongTerms) {
                DoubleTerms dTerms = LongTerms.convertLongTermsToDouble((LongTerms)agg, this.format);
                newAggs.add(dTerms);
                continue;
            }
            newAggs.add(agg);
        }
        return ((InternalAggregation)newAggs.get(0)).doReduce(newAggs, reduceContext);
    }

    static class Bucket
    extends InternalTerms.Bucket<Bucket> {
        private final double term;

        Bucket(double term, long docCount, InternalAggregations aggregations, boolean showDocCountError, long docCountError, DocValueFormat format) {
            super(docCount, aggregations, showDocCountError, docCountError, format);
            this.term = term;
        }

        Bucket(StreamInput in, DocValueFormat format, boolean showDocCountError) throws IOException {
            super(in, format, showDocCountError);
            this.term = in.readDouble();
        }

        @Override
        protected void writeTermTo(StreamOutput out) throws IOException {
            out.writeDouble(this.term);
        }

        @Override
        public String getKeyAsString() {
            return this.format.format(this.term).toString();
        }

        @Override
        public Object getKey() {
            return this.term;
        }

        @Override
        public Number getKeyAsNumber() {
            return this.term;
        }

        @Override
        public int compareKey(Bucket other) {
            return Double.compare(this.term, other.term);
        }

        @Override
        Bucket newBucket(long docCount, InternalAggregations aggs, long docCountError) {
            return new Bucket(this.term, docCount, aggs, this.showDocCountError, docCountError, this.format);
        }

        @Override
        protected final XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.term);
            if (this.format != DocValueFormat.RAW) {
                builder.field(Aggregation.CommonFields.KEY_AS_STRING.getPreferredName(), this.format.format(this.term).toString());
            }
            return builder;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && Objects.equals(this.term, ((Bucket)obj).term);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.term);
        }
    }
}

