/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.fetch.subphase;

import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.ReaderUtil;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.ScorerSupplier;
import conductor.org.apache.lucene.search.Weight;
import conductor.org.apache.lucene.util.Bits;
import conductor.org.elasticsearch.ExceptionsHelper;
import conductor.org.elasticsearch.common.lucene.Lucene;
import conductor.org.elasticsearch.search.SearchHit;
import conductor.org.elasticsearch.search.fetch.FetchSubPhase;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MatchedQueriesFetchSubPhase
implements FetchSubPhase {
    @Override
    public void hitsExecute(SearchContext context, SearchHit[] hits) {
        if (hits.length == 0 || context.parsedQuery() == null) {
            return;
        }
        hits = (SearchHit[])hits.clone();
        Arrays.sort(hits, (a, b) -> Integer.compare(a.docId(), b.docId()));
        List[] matchedQueries = new List[hits.length];
        for (int i = 0; i < matchedQueries.length; ++i) {
            matchedQueries[i] = new ArrayList();
        }
        HashMap<String, Query> namedQueries = new HashMap<String, Query>(context.parsedQuery().namedFilters());
        if (context.parsedPostFilter() != null) {
            namedQueries.putAll(context.parsedPostFilter().namedFilters());
        }
        try {
            for (Map.Entry entry : namedQueries.entrySet()) {
                String name = (String)entry.getKey();
                Query query = (Query)entry.getValue();
                int readerIndex = -1;
                int docBase = -1;
                Weight weight = context.searcher().createNormalizedWeight(query, false);
                Bits matchingDocs = null;
                IndexReader indexReader = context.searcher().getIndexReader();
                for (int i = 0; i < hits.length; ++i) {
                    SearchHit hit = hits[i];
                    int hitReaderIndex = ReaderUtil.subIndex(hit.docId(), indexReader.leaves());
                    if (readerIndex != hitReaderIndex) {
                        readerIndex = hitReaderIndex;
                        LeafReaderContext ctx = indexReader.leaves().get(readerIndex);
                        docBase = ctx.docBase;
                        ScorerSupplier scorerSupplier = weight.scorerSupplier(ctx);
                        matchingDocs = Lucene.asSequentialAccessBits(ctx.reader().maxDoc(), scorerSupplier);
                    }
                    if (!matchingDocs.get(hit.docId() - docBase)) continue;
                    matchedQueries[i].add(name);
                }
            }
            for (int i = 0; i < hits.length; ++i) {
                hits[i].matchedQueries(matchedQueries[i].toArray(new String[matchedQueries[i].size()]));
            }
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
        finally {
            context.clearReleasables(SearchContext.Lifetime.COLLECTION);
        }
    }
}

