/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.internal;

import conductor.org.elasticsearch.action.search.SearchScrollRequest;
import conductor.org.elasticsearch.action.search.SearchTask;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.search.Scroll;
import conductor.org.elasticsearch.tasks.Task;
import conductor.org.elasticsearch.tasks.TaskId;
import conductor.org.elasticsearch.transport.TransportRequest;
import java.io.IOException;
import java.util.Map;

public class InternalScrollSearchRequest
extends TransportRequest {
    private long id;
    private Scroll scroll;

    public InternalScrollSearchRequest() {
    }

    public InternalScrollSearchRequest(SearchScrollRequest request, long id) {
        this.id = id;
        this.scroll = request.scroll();
    }

    public long id() {
        return this.id;
    }

    public Scroll scroll() {
        return this.scroll;
    }

    public InternalScrollSearchRequest scroll(Scroll scroll) {
        this.scroll = scroll;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.id = in.readLong();
        this.scroll = in.readOptionalWriteable(Scroll::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.id);
        out.writeOptionalWriteable(this.scroll);
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new SearchTask(id, type, action, this.getDescription(), parentTaskId, headers);
    }

    @Override
    public String getDescription() {
        return "id[" + this.id + "], scroll[" + this.scroll + "]";
    }
}

