/*
 * Decompiled with CFR 0.152.
 */
package conductor.com.github.mustachejava.codes;

import conductor.com.github.mustachejava.Code;
import conductor.com.github.mustachejava.DefaultMustacheFactory;
import conductor.com.github.mustachejava.Mustache;
import conductor.com.github.mustachejava.MustacheException;
import conductor.com.github.mustachejava.TemplateContext;
import conductor.com.github.mustachejava.codes.CommentCode;
import conductor.com.github.mustachejava.codes.ExtendNameCode;
import conductor.com.github.mustachejava.codes.PartialCode;
import conductor.com.github.mustachejava.codes.WriteCode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ExtendCode
extends PartialCode {
    private final DefaultMustacheFactory mf;

    public ExtendCode(TemplateContext tc, DefaultMustacheFactory mf, Mustache codes, String name) throws MustacheException {
        super(tc, mf, codes, "<", name);
        this.mf = mf;
    }

    private Code[] replaceCodes(Code[] supercodes, Map<String, ExtendNameCode> replaceMap, Set<Code> seen) {
        Code[] newcodes = (Code[])supercodes.clone();
        for (int i = 0; i < supercodes.length; ++i) {
            Code code = supercodes[i];
            if (!seen.add(code)) continue;
            if (code instanceof ExtendNameCode) {
                ExtendNameCode enc = (ExtendNameCode)code;
                ExtendNameCode extendReplaceCode = replaceMap.get(enc.getName());
                if (extendReplaceCode != null) {
                    newcodes[i] = (Code)extendReplaceCode.clone();
                    ExtendNameCode newcode = (ExtendNameCode)newcodes[i];
                    newcode.appended = enc.appended;
                } else {
                    enc.setCodes(this.replaceCodes(enc.getCodes(), replaceMap, seen));
                }
            } else {
                Code[] codes = code.getCodes();
                if (codes != null) {
                    code.setCodes(this.replaceCodes(codes, replaceMap, seen));
                }
            }
            seen.remove(code);
        }
        return newcodes;
    }

    @Override
    public synchronized void init() {
        this.filterText();
        HashMap<String, ExtendNameCode> replaceMap = new HashMap<String, ExtendNameCode>();
        for (Code code : this.mustache.getCodes()) {
            if (code instanceof ExtendNameCode) {
                ExtendNameCode erc = (ExtendNameCode)code;
                replaceMap.put(erc.getName(), erc);
                erc.init();
                continue;
            }
            if (code instanceof WriteCode || code instanceof CommentCode) continue;
            throw new IllegalArgumentException("Illegal code in extend section: " + code.getClass().getName());
        }
        Mustache original = this.mf.compilePartial(this.partialName());
        this.partial = (Mustache)original.clone();
        Code[] supercodes = this.partial.getCodes();
        HashSet<Code> seen = new HashSet<Code>();
        seen.add(this.partial);
        this.partial.setCodes(this.replaceCodes(supercodes, replaceMap, seen));
    }
}

