/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.document;

import conductor.org.apache.lucene.document.FloatPoint;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.PointValues;
import conductor.org.apache.lucene.search.FieldDoc;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.ScoreDoc;
import conductor.org.apache.lucene.search.TopFieldDocs;
import conductor.org.apache.lucene.util.Bits;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.bkd.BKDReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;

public class FloatPointNearestNeighbor {
    private static NearestHit[] nearest(List<BKDReader> readers, List<Bits> liveDocs, List<Integer> docBases, int topN, float[] origin) throws IOException {
        BKDReader reader;
        PriorityQueue<NearestHit> hitQueue = new PriorityQueue<NearestHit>(topN, (a, b) -> {
            int cmp = Double.compare(a.distanceSquared, b.distanceSquared);
            return cmp != 0 ? -cmp : b.docID - a.docID;
        });
        PriorityQueue<Cell> cellQueue = new PriorityQueue<Cell>();
        NearestVisitor visitor = new NearestVisitor(hitQueue, topN, origin);
        ArrayList<BKDReader.IntersectState> states = new ArrayList<BKDReader.IntersectState>();
        int bytesPerDim = -1;
        for (int i = 0; i < readers.size(); ++i) {
            reader = readers.get(i);
            if (bytesPerDim == -1) {
                bytesPerDim = reader.getBytesPerDimension();
            } else if (bytesPerDim != reader.getBytesPerDimension()) {
                throw new IllegalStateException("bytesPerDim changed from " + bytesPerDim + " to " + reader.getBytesPerDimension() + " across readers");
            }
            byte[] minPackedValue = reader.getMinPackedValue();
            byte[] maxPackedValue = reader.getMaxPackedValue();
            BKDReader.IntersectState state = reader.getIntersectState(visitor);
            states.add(state);
            cellQueue.offer(new Cell(state.index, i, reader.getMinPackedValue(), reader.getMaxPackedValue(), FloatPointNearestNeighbor.approxBestDistanceSquared(minPackedValue, maxPackedValue, origin)));
        }
        block1: while (cellQueue.size() > 0) {
            Cell cell = (Cell)cellQueue.poll();
            reader = readers.get(cell.readerIndex);
            if (cell.index.isLeafNode()) {
                visitor.curDocBase = docBases.get(cell.readerIndex);
                visitor.curLiveDocs = liveDocs.get(cell.readerIndex);
                reader.visitLeafBlockValues(cell.index, (BKDReader.IntersectState)states.get(cell.readerIndex));
                continue;
            }
            if (hitQueue.size() == topN) {
                int d = 0;
                int offset = 0;
                while (d < visitor.dims) {
                    float cellMaxAtDim = FloatPoint.decodeDimension(cell.maxPacked, offset);
                    float cellMinAtDim = FloatPoint.decodeDimension(cell.minPacked, offset);
                    if (cellMaxAtDim < visitor.min[d] || cellMinAtDim > visitor.max[d]) continue block1;
                    ++d;
                    offset += 4;
                }
            }
            BytesRef splitValue = BytesRef.deepCopyOf(cell.index.getSplitDimValue());
            int splitDim = cell.index.getSplitDim();
            BKDReader.IndexTree newIndex = cell.index.clone();
            byte[] splitPackedValue = (byte[])cell.maxPacked.clone();
            System.arraycopy(splitValue.bytes, splitValue.offset, splitPackedValue, splitDim * bytesPerDim, bytesPerDim);
            cell.index.pushLeft();
            cellQueue.offer(new Cell(cell.index, cell.readerIndex, cell.minPacked, splitPackedValue, FloatPointNearestNeighbor.approxBestDistanceSquared(cell.minPacked, splitPackedValue, origin)));
            splitPackedValue = (byte[])cell.minPacked.clone();
            System.arraycopy(splitValue.bytes, splitValue.offset, splitPackedValue, splitDim * bytesPerDim, bytesPerDim);
            newIndex.pushRight();
            cellQueue.offer(new Cell(newIndex, cell.readerIndex, splitPackedValue, cell.maxPacked, FloatPointNearestNeighbor.approxBestDistanceSquared(splitPackedValue, cell.maxPacked, origin)));
        }
        NearestHit[] hits = new NearestHit[hitQueue.size()];
        int downTo = hitQueue.size() - 1;
        while (hitQueue.size() != 0) {
            hits[downTo] = hitQueue.poll();
            --downTo;
        }
        return hits;
    }

    private static double approxBestDistanceSquared(byte[] minPackedValue, byte[] maxPackedValue, float[] value) {
        boolean insideCell = true;
        float[] min = new float[value.length];
        float[] max = new float[value.length];
        double[] closest = new double[value.length];
        int i = 0;
        int offset = 0;
        while (i < value.length) {
            double maxDiff;
            double minDiff;
            min[i] = FloatPoint.decodeDimension(minPackedValue, offset);
            max[i] = FloatPoint.decodeDimension(maxPackedValue, offset);
            if (insideCell && (value[i] < min[i] || value[i] > max[i])) {
                insideCell = false;
            }
            closest[i] = (minDiff = Math.abs((double)value[i] - (double)min[i])) < (maxDiff = Math.abs((double)value[i] - (double)max[i])) ? minDiff : maxDiff;
            ++i;
            offset += 4;
        }
        if (insideCell) {
            return 0.0;
        }
        double sumOfSquaredDiffs = 0.0;
        for (int d = 0; d < value.length; ++d) {
            sumOfSquaredDiffs += closest[d] * closest[d];
        }
        return sumOfSquaredDiffs;
    }

    static double euclideanDistanceSquared(float[] a, float[] b) {
        double sumOfSquaredDifferences = 0.0;
        for (int d = 0; d < a.length; ++d) {
            double diff = (double)a[d] - (double)b[d];
            sumOfSquaredDifferences += diff * diff;
        }
        return sumOfSquaredDifferences;
    }

    public static TopFieldDocs nearest(IndexSearcher searcher, String field, int topN, float ... origin) throws IOException {
        if (topN < 1) {
            throw new IllegalArgumentException("topN must be at least 1; got " + topN);
        }
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (searcher == null) {
            throw new IllegalArgumentException("searcher must not be null");
        }
        ArrayList<BKDReader> readers = new ArrayList<BKDReader>();
        ArrayList<Integer> docBases = new ArrayList<Integer>();
        ArrayList<Bits> liveDocs = new ArrayList<Bits>();
        int totalHits = 0;
        for (LeafReaderContext leaf : searcher.getIndexReader().leaves()) {
            PointValues points = leaf.reader().getPointValues(field);
            if (points == null) continue;
            if (!(points instanceof BKDReader)) {
                throw new IllegalArgumentException("can only run on Lucene60PointsReader points implementation, but got " + points);
            }
            totalHits += points.getDocCount();
            readers.add((BKDReader)points);
            docBases.add(leaf.docBase);
            liveDocs.add(leaf.reader().getLiveDocs());
        }
        NearestHit[] hits = FloatPointNearestNeighbor.nearest(readers, liveDocs, docBases, topN, origin);
        ScoreDoc[] scoreDocs = new ScoreDoc[hits.length];
        for (int i = 0; i < hits.length; ++i) {
            NearestHit hit = hits[i];
            scoreDocs[i] = new FieldDoc(hit.docID, 0.0f, new Object[]{Float.valueOf((float)Math.sqrt(hit.distanceSquared))});
        }
        return new TopFieldDocs(totalHits, scoreDocs, null, 0.0f);
    }

    static class NearestHit {
        public int docID;
        public double distanceSquared;

        NearestHit() {
        }

        public String toString() {
            return "NearestHit(docID=" + this.docID + " distanceSquared=" + this.distanceSquared + ")";
        }
    }

    private static class NearestVisitor
    implements PointValues.IntersectVisitor {
        int curDocBase;
        Bits curLiveDocs;
        final int topN;
        final PriorityQueue<NearestHit> hitQueue;
        final float[] origin;
        private int dims;
        private int updateMinMaxCounter;
        private float[] min;
        private float[] max;
        private static final int MANTISSA_BITS = 23;

        public NearestVisitor(PriorityQueue<NearestHit> hitQueue, int topN, float[] origin) {
            this.hitQueue = hitQueue;
            this.topN = topN;
            this.origin = origin;
            this.dims = origin.length;
            this.min = new float[this.dims];
            this.max = new float[this.dims];
            Arrays.fill(this.min, Float.NEGATIVE_INFINITY);
            Arrays.fill(this.max, Float.POSITIVE_INFINITY);
        }

        @Override
        public void visit(int docID) {
            throw new AssertionError();
        }

        private float getMinDelta(float distance) {
            int exponent = Float.floatToIntBits(distance) >> 23;
            if (exponent == 0) {
                return Float.MIN_VALUE;
            }
            exponent = exponent <= 23 ? 1 : exponent - 23;
            return Float.intBitsToFloat(exponent << 23);
        }

        private void maybeUpdateMinMax() {
            if (this.updateMinMaxCounter < 1024 || (this.updateMinMaxCounter & 0x3F) == 63) {
                NearestHit hit = this.hitQueue.peek();
                float distance = (float)Math.sqrt(hit.distanceSquared);
                float minDelta = this.getMinDelta(distance);
                for (int d = 0; d < this.dims; ++d) {
                    this.min[d] = this.origin[d] - distance - minDelta;
                    this.max[d] = this.origin[d] + distance + minDelta;
                }
            }
            ++this.updateMinMaxCounter;
        }

        @Override
        public void visit(int docID, byte[] packedValue) {
            if (this.curLiveDocs != null && !this.curLiveDocs.get(docID)) {
                return;
            }
            float[] docPoint = new float[this.dims];
            int d = 0;
            int offset = 0;
            while (d < this.dims) {
                docPoint[d] = FloatPoint.decodeDimension(packedValue, offset);
                if (docPoint[d] > this.max[d] || docPoint[d] < this.min[d]) {
                    return;
                }
                ++d;
                offset += 4;
            }
            double distanceSquared = FloatPointNearestNeighbor.euclideanDistanceSquared(this.origin, docPoint);
            int fullDocID = this.curDocBase + docID;
            if (this.hitQueue.size() == this.topN) {
                NearestHit bottom = this.hitQueue.peek();
                if (distanceSquared < bottom.distanceSquared || distanceSquared == bottom.distanceSquared && fullDocID < bottom.docID) {
                    this.hitQueue.poll();
                    bottom.docID = fullDocID;
                    bottom.distanceSquared = distanceSquared;
                    this.hitQueue.offer(bottom);
                    this.maybeUpdateMinMax();
                }
            } else {
                NearestHit hit = new NearestHit();
                hit.docID = fullDocID;
                hit.distanceSquared = distanceSquared;
                this.hitQueue.offer(hit);
            }
        }

        @Override
        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
    }

    static class Cell
    implements Comparable<Cell> {
        final int readerIndex;
        final byte[] minPacked;
        final byte[] maxPacked;
        final BKDReader.IndexTree index;
        final double distanceSquared;

        Cell(BKDReader.IndexTree index, int readerIndex, byte[] minPacked, byte[] maxPacked, double distanceSquared) {
            this.index = index;
            this.readerIndex = readerIndex;
            this.minPacked = (byte[])minPacked.clone();
            this.maxPacked = (byte[])maxPacked.clone();
            this.distanceSquared = distanceSquared;
        }

        @Override
        public int compareTo(Cell other) {
            return Double.compare(this.distanceSquared, other.distanceSquared);
        }

        public String toString() {
            return "Cell(readerIndex=" + this.readerIndex + " nodeID=" + this.index.getNodeID() + " isLeaf=" + this.index.isLeafNode() + " distanceSquared=" + this.distanceSquared + ")";
        }
    }
}

