/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.intervals;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.PostingsEnum;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.index.Terms;
import conductor.org.apache.lucene.index.TermsEnum;
import conductor.org.apache.lucene.search.MatchesIterator;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.intervals.IntervalIterator;
import conductor.org.apache.lucene.search.intervals.IntervalsSource;
import conductor.org.apache.lucene.util.BytesRef;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;

class TermIntervalsSource
extends IntervalsSource {
    final BytesRef term;
    private static final int TERM_POSNS_SEEK_OPS_PER_DOC = 128;
    private static final int TERM_OPS_PER_POS = 7;

    TermIntervalsSource(BytesRef term) {
        this.term = term;
    }

    @Override
    public IntervalIterator intervals(String field, LeafReaderContext ctx) throws IOException {
        Terms terms = ctx.reader().terms(field);
        if (terms == null) {
            return null;
        }
        if (!terms.hasPositions()) {
            throw new IllegalArgumentException("Cannot create an IntervalIterator over field " + field + " because it has no indexed positions");
        }
        TermsEnum te = terms.iterator();
        if (!te.seekExact(this.term)) {
            return null;
        }
        final PostingsEnum pe = te.postings(null, 24);
        final float cost = TermIntervalsSource.termPositionsCost(te);
        return new IntervalIterator(){
            int pos = -1;
            int upto;

            @Override
            public int docID() {
                return pe.docID();
            }

            @Override
            public int nextDoc() throws IOException {
                int doc = pe.nextDoc();
                this.reset();
                return doc;
            }

            @Override
            public int advance(int target) throws IOException {
                int doc = pe.advance(target);
                this.reset();
                return doc;
            }

            @Override
            public long cost() {
                return pe.cost();
            }

            @Override
            public int start() {
                return this.pos;
            }

            @Override
            public int end() {
                return this.pos;
            }

            @Override
            public int nextInterval() throws IOException {
                if (this.upto <= 0) {
                    this.pos = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                --this.upto;
                this.pos = pe.nextPosition();
                return this.pos;
            }

            @Override
            public float matchCost() {
                return cost;
            }

            private void reset() throws IOException {
                if (pe.docID() == Integer.MAX_VALUE) {
                    this.upto = -1;
                    this.pos = Integer.MAX_VALUE;
                } else {
                    this.upto = pe.freq();
                    this.pos = -1;
                }
            }

            @Override
            public String toString() {
                return TermIntervalsSource.this.term.utf8ToString() + ":" + super.toString();
            }
        };
    }

    @Override
    public MatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
        Terms terms = ctx.reader().terms(field);
        if (terms == null) {
            return null;
        }
        if (!terms.hasPositions()) {
            throw new IllegalArgumentException("Cannot create an IntervalIterator over field " + field + " because it has no indexed positions");
        }
        TermsEnum te = terms.iterator();
        if (!te.seekExact(this.term)) {
            return null;
        }
        final PostingsEnum pe = te.postings(null, 56);
        if (pe.advance(doc) != doc) {
            return null;
        }
        return new MatchesIterator(){
            int upto;
            int pos;
            {
                this.upto = pe.freq();
                this.pos = -1;
            }

            @Override
            public boolean next() throws IOException {
                if (this.upto <= 0) {
                    this.pos = Integer.MAX_VALUE;
                    return false;
                }
                --this.upto;
                this.pos = pe.nextPosition();
                return true;
            }

            @Override
            public int startPosition() {
                return this.pos;
            }

            @Override
            public int endPosition() {
                return this.pos;
            }

            @Override
            public int startOffset() throws IOException {
                return pe.startOffset();
            }

            @Override
            public int endOffset() throws IOException {
                return pe.endOffset();
            }

            @Override
            public MatchesIterator getSubMatches() {
                return null;
            }

            @Override
            public Query getQuery() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.term);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermIntervalsSource that = (TermIntervalsSource)o;
        return Objects.equals(this.term, that.term);
    }

    @Override
    public String toString() {
        return this.term.utf8ToString();
    }

    @Override
    public void extractTerms(String field, Set<Term> terms) {
        terms.add(new Term(field, this.term));
    }

    static float termPositionsCost(TermsEnum termsEnum) throws IOException {
        int docFreq = termsEnum.docFreq();
        assert (docFreq > 0);
        long totalTermFreq = termsEnum.totalTermFreq();
        float expOccurrencesInMatchingDoc = (float)totalTermFreq / (float)docFreq;
        return 128.0f + expOccurrencesInMatchingDoc * 7.0f;
    }
}

