/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.spans;

import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.spans.SpanQuery;
import conductor.org.apache.lucene.search.spans.SpanWeight;
import java.io.IOException;
import java.util.Objects;

public final class SpanBoostQuery
extends SpanQuery {
    private final SpanQuery query;
    private final float boost;

    public SpanBoostQuery(SpanQuery query, float boost) {
        this.query = Objects.requireNonNull(query);
        this.boost = boost;
    }

    public SpanQuery getQuery() {
        return this.query;
    }

    public float getBoost() {
        return this.boost;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((SpanBoostQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(SpanBoostQuery other) {
        return this.query.equals(other.query) && Float.floatToIntBits(this.boost) == Float.floatToIntBits(other.boost);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.query.hashCode();
        h = 31 * h + Float.floatToIntBits(this.boost);
        return h;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.boost == 1.0f) {
            return this.query;
        }
        SpanQuery rewritten = (SpanQuery)this.query.rewrite(reader);
        if (this.query != rewritten) {
            return new SpanBoostQuery(rewritten, this.boost);
        }
        if (this.query.getClass() == SpanBoostQuery.class) {
            SpanBoostQuery in = (SpanBoostQuery)this.query;
            return new SpanBoostQuery(in.query, this.boost * in.boost);
        }
        return super.rewrite(reader);
    }

    @Override
    public String toString(String field) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        builder.append(this.query.toString(field));
        builder.append(")^");
        builder.append(this.boost);
        return builder.toString();
    }

    @Override
    public String getField() {
        return this.query.getField();
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        return this.query.createWeight(searcher, needsScores, this.boost * boost);
    }
}

