/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.spatial3d.geom;

import conductor.org.apache.lucene.spatial3d.geom.Bounds;
import conductor.org.apache.lucene.spatial3d.geom.DistanceStyle;
import conductor.org.apache.lucene.spatial3d.geom.GeoBBox;
import conductor.org.apache.lucene.spatial3d.geom.GeoBBoxFactory;
import conductor.org.apache.lucene.spatial3d.geom.GeoBaseBBox;
import conductor.org.apache.lucene.spatial3d.geom.GeoPoint;
import conductor.org.apache.lucene.spatial3d.geom.GeoShape;
import conductor.org.apache.lucene.spatial3d.geom.Membership;
import conductor.org.apache.lucene.spatial3d.geom.Plane;
import conductor.org.apache.lucene.spatial3d.geom.PlanetModel;
import conductor.org.apache.lucene.spatial3d.geom.SerializableObject;
import conductor.org.apache.lucene.spatial3d.geom.SidedPlane;
import conductor.org.apache.lucene.spatial3d.geom.Vector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class GeoDegenerateLongitudeSlice
extends GeoBaseBBox {
    protected final double longitude;
    protected final SidedPlane boundingPlane;
    protected final Plane plane;
    protected final GeoPoint interiorPoint;
    protected final GeoPoint[] edgePoints;
    protected final GeoPoint[] planePoints;

    public GeoDegenerateLongitudeSlice(PlanetModel planetModel, double longitude) {
        super(planetModel);
        if (longitude < -Math.PI || longitude > Math.PI) {
            throw new IllegalArgumentException("Longitude out of range");
        }
        this.longitude = longitude;
        double sinLongitude = Math.sin(longitude);
        double cosLongitude = Math.cos(longitude);
        this.plane = new Plane(cosLongitude, sinLongitude);
        this.interiorPoint = new GeoPoint(planetModel, 0.0, sinLongitude, 1.0, cosLongitude);
        this.boundingPlane = new SidedPlane((Vector)this.interiorPoint, -sinLongitude, cosLongitude);
        this.edgePoints = new GeoPoint[]{this.interiorPoint};
        this.planePoints = new GeoPoint[]{planetModel.NORTH_POLE, planetModel.SOUTH_POLE};
    }

    public GeoDegenerateLongitudeSlice(PlanetModel planetModel, InputStream inputStream) throws IOException {
        this(planetModel, SerializableObject.readDouble(inputStream));
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        SerializableObject.writeDouble(outputStream, this.longitude);
    }

    @Override
    public GeoBBox expand(double angle) {
        double newLeftLon = this.longitude - angle;
        double newRightLon = this.longitude + angle;
        double currentLonSpan = 2.0 * angle;
        if (currentLonSpan + 2.0 * angle >= Math.PI * 2) {
            newLeftLon = -Math.PI;
            newRightLon = Math.PI;
        }
        return GeoBBoxFactory.makeGeoBBox(this.planetModel, 1.5707963267948966, -1.5707963267948966, newLeftLon, newRightLon);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.plane.evaluateIsZero(x, y, z) && this.boundingPlane.isWithin(x, y, z);
    }

    @Override
    public double getRadius() {
        return 1.5707963267948966;
    }

    @Override
    public GeoPoint getCenter() {
        return this.interiorPoint;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        return p.intersects(this.planetModel, this.plane, notablePoints, this.planePoints, bounds, this.boundingPlane);
    }

    @Override
    public boolean intersects(GeoShape geoShape) {
        return geoShape.intersects(this.plane, this.planePoints, this.boundingPlane);
    }

    @Override
    public void getBounds(Bounds bounds) {
        super.getBounds(bounds);
        bounds.addVerticalPlane(this.planetModel, this.longitude, this.plane, this.boundingPlane).addPoint(this.planetModel.NORTH_POLE).addPoint(this.planetModel.SOUTH_POLE);
    }

    @Override
    public int getRelationship(GeoShape path) {
        if (this.intersects(path)) {
            return 2;
        }
        if (path.isWithin(this.interiorPoint)) {
            return 0;
        }
        return 3;
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        double distance = distanceStyle.computeDistance(this.planetModel, this.plane, x, y, z, this.boundingPlane);
        double northDistance = distanceStyle.computeDistance(this.planetModel.NORTH_POLE, x, y, z);
        double southDistance = distanceStyle.computeDistance(this.planetModel.SOUTH_POLE, x, y, z);
        return Math.min(distance, Math.min(northDistance, southDistance));
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoDegenerateLongitudeSlice)) {
            return false;
        }
        GeoDegenerateLongitudeSlice other = (GeoDegenerateLongitudeSlice)o;
        return super.equals(other) && other.longitude == this.longitude;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.longitude);
        result = result * 31 + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "GeoDegenerateLongitudeSlice: {planetmodel=" + this.planetModel + ", longitude=" + this.longitude + "(" + this.longitude * 180.0 / Math.PI + ")}";
    }
}

