/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.indices.exists.indices;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import conductor.org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.IndicesOptions;
import conductor.org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.block.ClusterBlockException;
import conductor.org.elasticsearch.cluster.block.ClusterBlockLevel;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.index.IndexNotFoundException;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;

public class TransportIndicesExistsAction
extends TransportMasterNodeReadAction<IndicesExistsRequest, IndicesExistsResponse> {
    @Inject
    public TransportIndicesExistsAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:admin/exists", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, IndicesExistsRequest::new);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected IndicesExistsResponse newResponse() {
        return new IndicesExistsResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(IndicesExistsRequest request, ClusterState state) {
        IndicesOptions indicesOptions = IndicesOptions.fromOptions(true, true, request.indicesOptions().expandWildcardsOpen(), request.indicesOptions().expandWildcardsClosed());
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNames(state, indicesOptions, request.indices()));
    }

    @Override
    protected void masterOperation(IndicesExistsRequest request, ClusterState state, ActionListener<IndicesExistsResponse> listener) {
        boolean exists;
        try {
            this.indexNameExpressionResolver.concreteIndexNames(state, request);
            exists = true;
        }
        catch (IndexNotFoundException e) {
            exists = false;
        }
        listener.onResponse(new IndicesExistsResponse(exists));
    }
}

