/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.termvectors;

import conductor.org.elasticsearch.action.RoutingMissingException;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import conductor.org.elasticsearch.action.termvectors.TermVectorsRequest;
import conductor.org.elasticsearch.action.termvectors.TermVectorsResponse;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.routing.GroupShardsIterator;
import conductor.org.elasticsearch.cluster.routing.ShardIterator;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.index.IndexService;
import conductor.org.elasticsearch.index.shard.IndexShard;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.index.termvectors.TermVectorsService;
import conductor.org.elasticsearch.indices.IndicesService;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;

public class TransportTermVectorsAction
extends TransportSingleShardAction<TermVectorsRequest, TermVectorsResponse> {
    private final IndicesService indicesService;

    @Inject
    public TransportTermVectorsAction(Settings settings, ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:data/read/tv", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, TermVectorsRequest::new, "get");
        this.indicesService = indicesService;
    }

    @Override
    protected ShardIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        if (((TermVectorsRequest)request.request()).doc() != null && ((TermVectorsRequest)request.request()).routing() == null) {
            GroupShardsIterator<ShardIterator> groupShardsIter = this.clusterService.operationRouting().searchShards(state, new String[]{request.concreteIndex()}, null, ((TermVectorsRequest)request.request()).preference());
            return groupShardsIter.iterator().next();
        }
        return this.clusterService.operationRouting().getShards(state, request.concreteIndex(), ((TermVectorsRequest)request.request()).id(), ((TermVectorsRequest)request.request()).routing(), ((TermVectorsRequest)request.request()).preference());
    }

    @Override
    protected boolean resolveIndex(TermVectorsRequest request) {
        return true;
    }

    @Override
    protected void resolveRequest(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        ((TermVectorsRequest)request.request()).routing(state.metaData().resolveIndexRouting(((TermVectorsRequest)request.request()).parent(), ((TermVectorsRequest)request.request()).routing(), ((TermVectorsRequest)request.request()).index()));
        if (((TermVectorsRequest)request.request()).routing() == null && state.getMetaData().routingRequired(request.concreteIndex(), ((TermVectorsRequest)request.request()).type())) {
            throw new RoutingMissingException(request.concreteIndex(), ((TermVectorsRequest)request.request()).type(), ((TermVectorsRequest)request.request()).id());
        }
    }

    @Override
    protected TermVectorsResponse shardOperation(TermVectorsRequest request, ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        return TermVectorsService.getTermVectors(indexShard, request);
    }

    @Override
    protected TermVectorsResponse newResponse() {
        return new TermVectorsResponse();
    }

    @Override
    protected String getExecutor(TermVectorsRequest request, ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        return indexService.getIndexSettings().isSearchThrottled() ? "search_throttled" : super.getExecutor(request, shardId);
    }
}

