/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client;

import conductor.org.elasticsearch.client.Request;
import conductor.org.elasticsearch.client.RequestConverters;
import conductor.org.elasticsearch.client.license.DeleteLicenseRequest;
import conductor.org.elasticsearch.client.license.GetLicenseRequest;
import conductor.org.elasticsearch.client.license.PutLicenseRequest;
import conductor.org.elasticsearch.client.license.StartBasicRequest;
import conductor.org.elasticsearch.client.license.StartTrialRequest;

final class LicenseRequestConverters {
    private LicenseRequestConverters() {
    }

    static Request putLicense(PutLicenseRequest putLicenseRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack", "license").build();
        Request request = new Request("PUT", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withTimeout(putLicenseRequest.timeout());
        parameters.withMasterTimeout(putLicenseRequest.masterNodeTimeout());
        if (putLicenseRequest.isAcknowledge()) {
            parameters.putParam("acknowledge", "true");
        }
        request.setJsonEntity(putLicenseRequest.getLicenseDefinition());
        return request;
    }

    static Request getLicense(GetLicenseRequest getLicenseRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack", "license").build();
        Request request = new Request("GET", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withLocal(getLicenseRequest.isLocal());
        return request;
    }

    static Request deleteLicense(DeleteLicenseRequest deleteLicenseRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack", "license").build();
        Request request = new Request("DELETE", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withTimeout(deleteLicenseRequest.timeout());
        parameters.withMasterTimeout(deleteLicenseRequest.masterNodeTimeout());
        return request;
    }

    static Request startTrial(StartTrialRequest startTrialRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack", "license", "start_trial").build();
        Request request = new Request("POST", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.putParam("acknowledge", Boolean.toString(startTrialRequest.isAcknowledge()));
        if (startTrialRequest.getLicenseType() != null) {
            parameters.putParam("type", startTrialRequest.getLicenseType());
        }
        return request;
    }

    static Request startBasic(StartBasicRequest startBasicRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack", "license", "start_basic").build();
        Request request = new Request("POST", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withTimeout(startBasicRequest.timeout());
        parameters.withMasterTimeout(startBasicRequest.masterNodeTimeout());
        if (startBasicRequest.isAcknowledge()) {
            parameters.putParam("acknowledge", "true");
        }
        return request;
    }
}

