/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.lucene.search.function;

import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.elasticsearch.common.lucene.search.function.CombineFunction;
import conductor.org.elasticsearch.common.lucene.search.function.LeafScoreFunction;
import java.io.IOException;
import java.util.Objects;

public abstract class ScoreFunction {
    private final CombineFunction scoreCombiner;

    protected ScoreFunction(CombineFunction scoreCombiner) {
        this.scoreCombiner = scoreCombiner;
    }

    public CombineFunction getDefaultScoreCombiner() {
        return this.scoreCombiner;
    }

    public abstract LeafScoreFunction getLeafScoreFunction(LeafReaderContext var1) throws IOException;

    public abstract boolean needsScores();

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ScoreFunction other = (ScoreFunction)obj;
        return Objects.equals(this.scoreCombiner, other.scoreCombiner) && this.doEquals(other);
    }

    public float getWeight() {
        return 1.0f;
    }

    protected abstract boolean doEquals(ScoreFunction var1);

    public final int hashCode() {
        return Objects.hash(this.scoreCombiner, this.doHashCode());
    }

    protected abstract int doHashCode();

    protected ScoreFunction rewrite(IndexReader reader) throws IOException {
        return this;
    }
}

