/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.unit;

import conductor.org.elasticsearch.ElasticsearchParseException;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import conductor.org.elasticsearch.common.unit.SizeUnit;
import java.io.IOException;

public class SizeValue
implements Writeable,
Comparable<SizeValue> {
    private final long size;
    private final SizeUnit sizeUnit;

    public SizeValue(long singles) {
        this(singles, SizeUnit.SINGLE);
    }

    public SizeValue(long size, SizeUnit sizeUnit) {
        if (size < 0L) {
            throw new IllegalArgumentException("size in SizeValue may not be negative");
        }
        this.size = size;
        this.sizeUnit = sizeUnit;
    }

    public SizeValue(StreamInput in) throws IOException {
        this.size = in.readVLong();
        this.sizeUnit = SizeUnit.SINGLE;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.singles());
    }

    public long singles() {
        return this.sizeUnit.toSingles(this.size);
    }

    public long getSingles() {
        return this.singles();
    }

    public long kilo() {
        return this.sizeUnit.toKilo(this.size);
    }

    public long getKilo() {
        return this.kilo();
    }

    public long mega() {
        return this.sizeUnit.toMega(this.size);
    }

    public long getMega() {
        return this.mega();
    }

    public long giga() {
        return this.sizeUnit.toGiga(this.size);
    }

    public long getGiga() {
        return this.giga();
    }

    public long tera() {
        return this.sizeUnit.toTera(this.size);
    }

    public long getTera() {
        return this.tera();
    }

    public long peta() {
        return this.sizeUnit.toPeta(this.size);
    }

    public long getPeta() {
        return this.peta();
    }

    public double kiloFrac() {
        return (double)this.singles() / 1000.0;
    }

    public double getKiloFrac() {
        return this.kiloFrac();
    }

    public double megaFrac() {
        return (double)this.singles() / 1000000.0;
    }

    public double getMegaFrac() {
        return this.megaFrac();
    }

    public double gigaFrac() {
        return (double)this.singles() / 1.0E9;
    }

    public double getGigaFrac() {
        return this.gigaFrac();
    }

    public double teraFrac() {
        return (double)this.singles() / 1.0E12;
    }

    public double getTeraFrac() {
        return this.teraFrac();
    }

    public double petaFrac() {
        return (double)this.singles() / 1.0E15;
    }

    public double getPetaFrac() {
        return this.petaFrac();
    }

    public String toString() {
        long singles = this.singles();
        double value = singles;
        String suffix = "";
        if (singles >= 1000000000000000L) {
            value = this.petaFrac();
            suffix = "p";
        } else if (singles >= 1000000000000L) {
            value = this.teraFrac();
            suffix = "t";
        } else if (singles >= 1000000000L) {
            value = this.gigaFrac();
            suffix = "g";
        } else if (singles >= 1000000L) {
            value = this.megaFrac();
            suffix = "m";
        } else if (singles >= 1000L) {
            value = this.kiloFrac();
            suffix = "k";
        }
        return Strings.format1Decimals(value, suffix);
    }

    public static SizeValue parseSizeValue(String sValue) throws ElasticsearchParseException {
        return SizeValue.parseSizeValue(sValue, null);
    }

    public static SizeValue parseSizeValue(String sValue, SizeValue defaultValue) throws ElasticsearchParseException {
        long singles;
        if (sValue == null) {
            return defaultValue;
        }
        try {
            singles = sValue.endsWith("k") || sValue.endsWith("K") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 1000.0) : (sValue.endsWith("m") || sValue.endsWith("M") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 1000000.0) : (sValue.endsWith("g") || sValue.endsWith("G") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 1.0E9) : (sValue.endsWith("t") || sValue.endsWith("T") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 1.0E12) : (sValue.endsWith("p") || sValue.endsWith("P") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 1.0E15) : Long.parseLong(sValue)))));
        }
        catch (NumberFormatException e) {
            throw new ElasticsearchParseException("failed to parse [{}]", (Throwable)e, sValue);
        }
        return new SizeValue(singles, SizeUnit.SINGLE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.compareTo((SizeValue)o) == 0;
    }

    public int hashCode() {
        return Double.hashCode((double)this.size * (double)this.sizeUnit.toSingles(1L));
    }

    @Override
    public int compareTo(SizeValue other) {
        double thisValue = (double)this.size * (double)this.sizeUnit.toSingles(1L);
        double otherValue = (double)other.size * (double)other.sizeUnit.toSingles(1L);
        return Double.compare(thisValue, otherValue);
    }
}

