/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.discovery;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.logging.log4j.Logger;
import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.discovery.BlockingClusterStatePublishResponseHandler;
import conductor.org.elasticsearch.discovery.Discovery;
import java.util.Set;

public class AckClusterStatePublishResponseHandler
extends BlockingClusterStatePublishResponseHandler {
    private static final Logger logger = LogManager.getLogger(AckClusterStatePublishResponseHandler.class);
    private final Discovery.AckListener ackListener;

    public AckClusterStatePublishResponseHandler(Set<DiscoveryNode> publishingToNodes, Discovery.AckListener ackListener) {
        super(publishingToNodes);
        this.ackListener = ackListener;
    }

    @Override
    public void onResponse(DiscoveryNode node) {
        super.onResponse(node);
        this.onNodeAck(this.ackListener, node, null);
    }

    @Override
    public void onFailure(DiscoveryNode node, Exception e) {
        try {
            super.onFailure(node, e);
        }
        finally {
            this.onNodeAck(this.ackListener, node, e);
        }
    }

    private void onNodeAck(Discovery.AckListener ackListener, DiscoveryNode node, Exception e) {
        try {
            ackListener.onNodeAck(node, e);
        }
        catch (Exception inner) {
            inner.addSuppressed(e);
            logger.debug(() -> new ParameterizedMessage("error while processing ack for node [{}]", (Object)node), (Throwable)inner);
        }
    }
}

