/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.reindex;

import conductor.org.apache.logging.log4j.Logger;
import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.elasticsearch.ExceptionsHelper;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.bulk.BackoffPolicy;
import conductor.org.elasticsearch.action.search.ClearScrollRequest;
import conductor.org.elasticsearch.action.search.ClearScrollResponse;
import conductor.org.elasticsearch.action.search.SearchRequest;
import conductor.org.elasticsearch.action.search.SearchResponse;
import conductor.org.elasticsearch.action.search.SearchScrollRequest;
import conductor.org.elasticsearch.action.search.ShardSearchFailure;
import conductor.org.elasticsearch.client.ParentTaskAssigningClient;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.document.DocumentField;
import conductor.org.elasticsearch.common.unit.TimeValue;
import conductor.org.elasticsearch.common.util.CollectionUtils;
import conductor.org.elasticsearch.common.util.concurrent.AbstractRunnable;
import conductor.org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import conductor.org.elasticsearch.common.xcontent.XContentHelper;
import conductor.org.elasticsearch.common.xcontent.XContentType;
import conductor.org.elasticsearch.index.reindex.ScrollableHitSource;
import conductor.org.elasticsearch.search.SearchHit;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

public class ClientScrollableHitSource
extends ScrollableHitSource {
    private final ParentTaskAssigningClient client;
    private final SearchRequest firstSearchRequest;

    public ClientScrollableHitSource(Logger logger, BackoffPolicy backoffPolicy, ThreadPool threadPool, Runnable countSearchRetry, Consumer<Exception> fail, ParentTaskAssigningClient client, SearchRequest firstSearchRequest) {
        super(logger, backoffPolicy, threadPool, countSearchRetry, fail);
        this.client = client;
        this.firstSearchRequest = firstSearchRequest;
    }

    @Override
    public void doStart(Consumer<? super ScrollableHitSource.Response> onResponse) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executing initial scroll against {}{}", (Object)(CollectionUtils.isEmpty(this.firstSearchRequest.indices()) ? "all indices" : this.firstSearchRequest.indices()), (Object)(CollectionUtils.isEmpty(this.firstSearchRequest.types()) ? "" : this.firstSearchRequest.types()));
        }
        this.searchWithRetry(listener -> this.client.search(this.firstSearchRequest, (ActionListener<SearchResponse>)listener), r -> this.consume((SearchResponse)r, onResponse));
    }

    @Override
    protected void doStartNextScroll(String scrollId, TimeValue extraKeepAlive, Consumer<? super ScrollableHitSource.Response> onResponse) {
        this.searchWithRetry(listener -> {
            SearchScrollRequest request = new SearchScrollRequest();
            request.scrollId(scrollId).scroll(TimeValue.timeValueNanos(this.firstSearchRequest.scroll().keepAlive().nanos() + extraKeepAlive.nanos()));
            this.client.searchScroll(request, (ActionListener<SearchResponse>)listener);
        }, r -> this.consume((SearchResponse)r, onResponse));
    }

    @Override
    public void clearScroll(final String scrollId, final Runnable onCompletion) {
        ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
        clearScrollRequest.addScrollId(scrollId);
        this.client.unwrap().clearScroll(clearScrollRequest, new ActionListener<ClearScrollResponse>(){

            @Override
            public void onResponse(ClearScrollResponse response) {
                ClientScrollableHitSource.this.logger.debug("Freed [{}] contexts", (Object)response.getNumFreed());
                onCompletion.run();
            }

            @Override
            public void onFailure(Exception e) {
                ClientScrollableHitSource.this.logger.warn(() -> new ParameterizedMessage("Failed to clear scroll [{}]", (Object)scrollId), (Throwable)e);
                onCompletion.run();
            }
        });
    }

    @Override
    protected void cleanup(Runnable onCompletion) {
        onCompletion.run();
    }

    private void searchWithRetry(final Consumer<ActionListener<SearchResponse>> action, final Consumer<SearchResponse> onResponse) {
        class RetryHelper
        extends AbstractRunnable
        implements ActionListener<SearchResponse> {
            private final Iterator<TimeValue> retries;
            private Runnable retryWithContext;
            private volatile int retryCount;

            RetryHelper() {
                this.retries = ClientScrollableHitSource.this.backoffPolicy.iterator();
                this.retryCount = 0;
            }

            @Override
            protected void doRun() throws Exception {
                action.accept(this);
            }

            @Override
            public void onResponse(SearchResponse response) {
                onResponse.accept(response);
            }

            @Override
            public void onFailure(Exception e) {
                if (ExceptionsHelper.unwrap(e, EsRejectedExecutionException.class) != null) {
                    if (this.retries.hasNext()) {
                        ++this.retryCount;
                        TimeValue delay = this.retries.next();
                        ClientScrollableHitSource.this.logger.trace(() -> new ParameterizedMessage("retrying rejected search after [{}]", (Object)delay), (Throwable)e);
                        ClientScrollableHitSource.this.countSearchRetry.run();
                        ClientScrollableHitSource.this.threadPool.schedule(delay, "same", this.retryWithContext);
                    } else {
                        ClientScrollableHitSource.this.logger.warn(() -> new ParameterizedMessage("giving up on search because we retried [{}] times without success", (Object)this.retryCount), (Throwable)e);
                        ClientScrollableHitSource.this.fail.accept(e);
                    }
                } else {
                    ClientScrollableHitSource.this.logger.warn("giving up on search because it failed with a non-retryable exception", (Throwable)e);
                    ClientScrollableHitSource.this.fail.accept(e);
                }
            }
        }
        RetryHelper helper = new RetryHelper();
        helper.retryWithContext = this.threadPool.getThreadContext().preserveContext(helper);
        helper.run();
    }

    private void consume(SearchResponse response, Consumer<? super ScrollableHitSource.Response> onResponse) {
        onResponse.accept(this.wrap(response));
    }

    private ScrollableHitSource.Response wrap(SearchResponse response) {
        List hits;
        List<ScrollableHitSource.SearchFailure> failures;
        if (response.getShardFailures() == null) {
            failures = Collections.emptyList();
        } else {
            failures = new ArrayList(response.getShardFailures().length);
            for (ShardSearchFailure failure : response.getShardFailures()) {
                String nodeId = failure.shard() == null ? null : failure.shard().getNodeId();
                failures.add(new ScrollableHitSource.SearchFailure(failure.getCause(), failure.index(), failure.shardId(), nodeId));
            }
        }
        if (response.getHits().getHits() == null || response.getHits().getHits().length == 0) {
            hits = Collections.emptyList();
        } else {
            hits = new ArrayList(response.getHits().getHits().length);
            for (SearchHit hit : response.getHits().getHits()) {
                hits.add(new ClientHit(hit));
            }
            hits = Collections.unmodifiableList(hits);
        }
        return new ScrollableHitSource.Response(response.isTimedOut(), failures, response.getHits().getTotalHits(), hits, response.getScrollId());
    }

    private static class ClientHit
    implements ScrollableHitSource.Hit {
        private final SearchHit delegate;
        private final BytesReference source;

        ClientHit(SearchHit delegate) {
            this.delegate = delegate;
            this.source = delegate.hasSource() ? delegate.getSourceRef() : null;
        }

        @Override
        public String getIndex() {
            return this.delegate.getIndex();
        }

        @Override
        public String getType() {
            return this.delegate.getType();
        }

        @Override
        public String getId() {
            return this.delegate.getId();
        }

        @Override
        public BytesReference getSource() {
            return this.source;
        }

        @Override
        public XContentType getXContentType() {
            return XContentHelper.xContentType(this.source);
        }

        @Override
        public long getVersion() {
            return this.delegate.getVersion();
        }

        @Override
        public String getParent() {
            return (String)this.fieldValue("_parent");
        }

        @Override
        public String getRouting() {
            return (String)this.fieldValue("_routing");
        }

        private <T> T fieldValue(String fieldName) {
            DocumentField field = this.delegate.field(fieldName);
            return field == null ? null : (T)field.getValue();
        }
    }
}

