/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.query;

import conductor.org.elasticsearch.action.IndicesRequest;
import conductor.org.elasticsearch.action.OriginalIndices;
import conductor.org.elasticsearch.action.search.SearchTask;
import conductor.org.elasticsearch.action.support.IndicesOptions;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.search.dfs.AggregatedDfs;
import conductor.org.elasticsearch.tasks.Task;
import conductor.org.elasticsearch.tasks.TaskId;
import conductor.org.elasticsearch.transport.TransportRequest;
import java.io.IOException;
import java.util.Map;

public class QuerySearchRequest
extends TransportRequest
implements IndicesRequest {
    private long id;
    private AggregatedDfs dfs;
    private OriginalIndices originalIndices;

    public QuerySearchRequest() {
    }

    public QuerySearchRequest(OriginalIndices originalIndices, long id, AggregatedDfs dfs) {
        this.id = id;
        this.dfs = dfs;
        this.originalIndices = originalIndices;
    }

    public long id() {
        return this.id;
    }

    public AggregatedDfs dfs() {
        return this.dfs;
    }

    @Override
    public String[] indices() {
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.originalIndices.indicesOptions();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.id = in.readLong();
        this.dfs = AggregatedDfs.readAggregatedDfs(in);
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.id);
        this.dfs.writeTo(out);
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new SearchTask(id, type, action, this.getDescription(), parentTaskId, headers);
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("id[");
        sb.append(this.id);
        sb.append("], ");
        sb.append("indices[");
        Strings.arrayToDelimitedString(this.originalIndices.indices(), ",", sb);
        sb.append("]");
        return sb.toString();
    }
}

