/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search;

import conductor.org.apache.lucene.search.DisjunctionMatchesIterator;
import conductor.org.apache.lucene.search.Matches;
import conductor.org.apache.lucene.search.MatchesIterator;
import conductor.org.apache.lucene.util.IOSupplier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class MatchesUtils {
    public static final Matches MATCH_WITH_NO_TERMS = new Matches(){

        @Override
        public Iterator<String> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public MatchesIterator getMatches(String field) {
            return null;
        }
    };

    private MatchesUtils() {
    }

    public static Matches fromSubMatches(List<Matches> subMatches) {
        if (subMatches == null || subMatches.size() == 0) {
            return null;
        }
        final List sm = subMatches.stream().filter(m -> m != MATCH_WITH_NO_TERMS).collect(Collectors.toList());
        if (sm.size() == 0) {
            return MATCH_WITH_NO_TERMS;
        }
        if (sm.size() == 1) {
            return (Matches)sm.get(0);
        }
        return new Matches(){

            @Override
            public MatchesIterator getMatches(String field) throws IOException {
                ArrayList<MatchesIterator> subIterators = new ArrayList<MatchesIterator>(sm.size());
                for (Matches m : sm) {
                    MatchesIterator it = m.getMatches(field);
                    if (it == null) continue;
                    subIterators.add(it);
                }
                return DisjunctionMatchesIterator.fromSubIterators(subIterators);
            }

            @Override
            public Iterator<String> iterator() {
                return sm.stream().flatMap(m -> StreamSupport.stream(m.spliterator(), false)).distinct().iterator();
            }
        };
    }

    public static Matches forField(final String field, final IOSupplier<MatchesIterator> mis) throws IOException {
        final MatchesIterator mi = mis.get();
        if (mi == null) {
            return null;
        }
        return new Matches(){
            boolean cached = true;

            @Override
            public MatchesIterator getMatches(String f) throws IOException {
                if (!Objects.equals(field, f)) {
                    return null;
                }
                if (!this.cached) {
                    return (MatchesIterator)mis.get();
                }
                this.cached = false;
                return mi;
            }

            @Override
            public Iterator<String> iterator() {
                return Collections.singleton(field).iterator();
            }
        };
    }

    public static MatchesIterator disjunction(List<MatchesIterator> subMatches) throws IOException {
        return DisjunctionMatchesIterator.fromSubIterators(subMatches);
    }
}

