/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.intervals;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.search.FilterMatchesIterator;
import conductor.org.apache.lucene.search.MatchesIterator;
import conductor.org.apache.lucene.search.MatchesUtils;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.intervals.IntervalFunction;
import conductor.org.apache.lucene.search.intervals.IntervalIterator;
import conductor.org.apache.lucene.search.intervals.IntervalMatches;
import conductor.org.apache.lucene.search.intervals.IntervalsSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

class ConjunctionIntervalsSource
extends IntervalsSource {
    protected final List<IntervalsSource> subSources;
    protected final IntervalFunction function;

    ConjunctionIntervalsSource(List<IntervalsSource> subSources, IntervalFunction function) {
        this.subSources = subSources;
        this.function = function;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConjunctionIntervalsSource that = (ConjunctionIntervalsSource)o;
        return Objects.equals(this.subSources, that.subSources) && Objects.equals(this.function, that.function);
    }

    @Override
    public String toString() {
        return this.function + this.subSources.stream().map(Object::toString).collect(Collectors.joining(",", "(", ")"));
    }

    @Override
    public void extractTerms(String field, Set<Term> terms) {
        for (IntervalsSource source : this.subSources) {
            source.extractTerms(field, terms);
        }
    }

    @Override
    public IntervalIterator intervals(String field, LeafReaderContext ctx) throws IOException {
        ArrayList<IntervalIterator> subIntervals = new ArrayList<IntervalIterator>();
        for (IntervalsSource source : this.subSources) {
            IntervalIterator it = source.intervals(field, ctx);
            if (it == null) {
                return null;
            }
            subIntervals.add(it);
        }
        return this.function.apply(subIntervals);
    }

    @Override
    public MatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
        ArrayList<MatchesIterator> subs = new ArrayList<MatchesIterator>();
        for (IntervalsSource source : this.subSources) {
            MatchesIterator mi = source.matches(field, ctx, doc);
            if (mi == null) {
                return null;
            }
            subs.add(mi);
        }
        IntervalIterator it = this.function.apply(subs.stream().map(m -> IntervalMatches.wrapMatches(m, doc)).collect(Collectors.toList()));
        if (it.advance(doc) != doc) {
            return null;
        }
        if (it.nextInterval() == Integer.MAX_VALUE) {
            return null;
        }
        return new ConjunctionMatchesIterator(it, subs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.subSources, this.function);
    }

    private static class SingletonMatchesIterator
    extends FilterMatchesIterator {
        boolean exhausted = false;

        SingletonMatchesIterator(MatchesIterator in) {
            super(in);
        }

        @Override
        public boolean next() {
            if (this.exhausted) {
                return false;
            }
            this.exhausted = true;
            return true;
        }
    }

    private static class ConjunctionMatchesIterator
    implements MatchesIterator {
        final IntervalIterator iterator;
        final List<MatchesIterator> subs;
        boolean cached = true;

        private ConjunctionMatchesIterator(IntervalIterator iterator, List<MatchesIterator> subs) {
            this.iterator = iterator;
            this.subs = subs;
        }

        @Override
        public boolean next() throws IOException {
            if (this.cached) {
                this.cached = false;
                return true;
            }
            return this.iterator.nextInterval() != Integer.MAX_VALUE;
        }

        @Override
        public int startPosition() {
            return this.iterator.start();
        }

        @Override
        public int endPosition() {
            return this.iterator.end();
        }

        @Override
        public int startOffset() throws IOException {
            int start = Integer.MAX_VALUE;
            for (MatchesIterator s : this.subs) {
                start = Math.min(start, s.startOffset());
            }
            return start;
        }

        @Override
        public int endOffset() throws IOException {
            int end = -1;
            for (MatchesIterator s : this.subs) {
                end = Math.max(end, s.endOffset());
            }
            return end;
        }

        @Override
        public MatchesIterator getSubMatches() throws IOException {
            ArrayList<MatchesIterator> subMatches = new ArrayList<MatchesIterator>();
            for (MatchesIterator mi : this.subs) {
                MatchesIterator sub = mi.getSubMatches();
                if (sub == null) {
                    sub = new SingletonMatchesIterator(mi);
                }
                subMatches.add(sub);
            }
            return MatchesUtils.disjunction(subMatches);
        }

        @Override
        public Query getQuery() {
            throw new UnsupportedOperationException();
        }
    }
}

