/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.intervals;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.search.MatchesIterator;
import conductor.org.apache.lucene.search.intervals.IntervalFilter;
import conductor.org.apache.lucene.search.intervals.IntervalIterator;
import conductor.org.apache.lucene.search.intervals.IntervalMatches;
import conductor.org.apache.lucene.search.intervals.IntervalsSource;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;

class LowpassIntervalsSource
extends IntervalsSource {
    final IntervalsSource in;
    private final int maxWidth;

    LowpassIntervalsSource(IntervalsSource in, int maxWidth) {
        this.in = in;
        this.maxWidth = maxWidth;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LowpassIntervalsSource that = (LowpassIntervalsSource)o;
        return this.maxWidth == that.maxWidth && Objects.equals(this.in, that.in);
    }

    @Override
    public String toString() {
        return "MAXWIDTH/" + this.maxWidth + "(" + this.in + ")";
    }

    @Override
    public void extractTerms(String field, Set<Term> terms) {
        this.in.extractTerms(field, terms);
    }

    @Override
    public IntervalIterator intervals(String field, LeafReaderContext ctx) throws IOException {
        final IntervalIterator i = this.in.intervals(field, ctx);
        if (i == null) {
            return null;
        }
        return new IntervalFilter(i){

            @Override
            protected boolean accept() {
                return i.end() - i.start() + 1 <= LowpassIntervalsSource.this.maxWidth;
            }
        };
    }

    @Override
    public MatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
        MatchesIterator mi = this.in.matches(field, ctx, doc);
        if (mi == null) {
            return null;
        }
        IntervalFilter filtered = new IntervalFilter(IntervalMatches.wrapMatches(mi, doc)){

            @Override
            protected boolean accept() {
                return this.in.end() - this.in.start() + 1 <= LowpassIntervalsSource.this.maxWidth;
            }
        };
        return IntervalMatches.asMatches(filtered, mi, doc);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.in, this.maxWidth);
    }
}

