/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.suggest;

import conductor.org.apache.lucene.search.suggest.fst.BytesRefSorter;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.BytesRefArray;
import conductor.org.apache.lucene.util.BytesRefIterator;
import conductor.org.apache.lucene.util.Counter;
import java.util.Comparator;

public final class InMemorySorter
implements BytesRefSorter {
    private final BytesRefArray buffer = new BytesRefArray(Counter.newCounter());
    private boolean closed = false;
    private final Comparator<BytesRef> comparator;

    public InMemorySorter(Comparator<BytesRef> comparator) {
        this.comparator = comparator;
    }

    @Override
    public void add(BytesRef utf8) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        this.buffer.append(utf8);
    }

    @Override
    public BytesRefIterator iterator() {
        this.closed = true;
        return this.buffer.iterator(this.comparator);
    }

    @Override
    public Comparator<BytesRef> getComparator() {
        return this.comparator;
    }
}

