/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.spatial3d;

import conductor.org.apache.lucene.index.LeafReader;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.PointValues;
import conductor.org.apache.lucene.search.ConstantScoreScorer;
import conductor.org.apache.lucene.search.ConstantScoreWeight;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.Scorer;
import conductor.org.apache.lucene.search.Weight;
import conductor.org.apache.lucene.spatial3d.PointInShapeIntersectVisitor;
import conductor.org.apache.lucene.spatial3d.geom.BasePlanetObject;
import conductor.org.apache.lucene.spatial3d.geom.GeoShape;
import conductor.org.apache.lucene.spatial3d.geom.PlanetModel;
import conductor.org.apache.lucene.spatial3d.geom.XYZBounds;
import conductor.org.apache.lucene.util.DocIdSetBuilder;
import java.io.IOException;

final class PointInGeo3DShapeQuery
extends Query {
    final String field;
    final GeoShape shape;
    final XYZBounds shapeBounds;

    public PointInGeo3DShapeQuery(String field, GeoShape shape) {
        BasePlanetObject planetObject;
        this.field = field;
        this.shape = shape;
        this.shapeBounds = new XYZBounds();
        shape.getBounds(this.shapeBounds);
        if (shape instanceof BasePlanetObject && !(planetObject = (BasePlanetObject)((Object)shape)).getPlanetModel().equals(PlanetModel.WGS84)) {
            throw new IllegalArgumentException("this qurey requires PlanetModel.WGS84, but got: " + planetObject.getPlanetModel());
        }
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                LeafReader reader = context.reader();
                PointValues values = reader.getPointValues(PointInGeo3DShapeQuery.this.field);
                if (values == null) {
                    return null;
                }
                DocIdSetBuilder result = new DocIdSetBuilder(reader.maxDoc(), values, PointInGeo3DShapeQuery.this.field);
                values.intersect(new PointInShapeIntersectVisitor(result, PointInGeo3DShapeQuery.this.shape, PointInGeo3DShapeQuery.this.shapeBounds));
                return new ConstantScoreScorer((Weight)this, this.score(), result.build().iterator());
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    public String getField() {
        return this.field;
    }

    public GeoShape getShape() {
        return this.shape;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((PointInGeo3DShapeQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(PointInGeo3DShapeQuery other) {
        return this.field.equals(other.field) && this.shape.equals(other.shape);
    }

    @Override
    public int hashCode() {
        int result = this.classHash();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + this.shape.hashCode();
        return result;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append(" Shape: ");
        sb.append(this.shape);
        return sb.toString();
    }
}

