/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.cluster.tasks;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.cluster.tasks.PendingClusterTasksRequest;
import conductor.org.elasticsearch.action.admin.cluster.tasks.PendingClusterTasksResponse;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.block.ClusterBlockException;
import conductor.org.elasticsearch.cluster.block.ClusterBlockLevel;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.cluster.service.PendingClusterTask;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.util.List;

public class TransportPendingClusterTasksAction
extends TransportMasterNodeReadAction<PendingClusterTasksRequest, PendingClusterTasksResponse> {
    private final ClusterService clusterService;

    @Inject
    public TransportPendingClusterTasksAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:monitor/task", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, PendingClusterTasksRequest::new);
        this.clusterService = clusterService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterBlockException checkBlock(PendingClusterTasksRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected PendingClusterTasksResponse newResponse() {
        return new PendingClusterTasksResponse();
    }

    @Override
    protected void masterOperation(PendingClusterTasksRequest request, ClusterState state, ActionListener<PendingClusterTasksResponse> listener) {
        this.logger.trace("fetching pending tasks from cluster service");
        List<PendingClusterTask> pendingTasks = this.clusterService.getMasterService().pendingTasks();
        this.logger.trace("done fetching pending tasks from cluster service");
        listener.onResponse(new PendingClusterTasksResponse(pendingTasks));
    }
}

