/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.indices.template.get;

import conductor.org.elasticsearch.action.ActionRequestValidationException;
import conductor.org.elasticsearch.action.ValidateActions;
import conductor.org.elasticsearch.action.support.master.MasterNodeReadRequest;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import java.io.IOException;

public class GetIndexTemplatesRequest
extends MasterNodeReadRequest<GetIndexTemplatesRequest> {
    private String[] names;

    public GetIndexTemplatesRequest() {
    }

    public GetIndexTemplatesRequest(String ... names) {
        this.names = names;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.names == null) {
            validationException = ValidateActions.addValidationError("names is null or empty", validationException);
        } else {
            for (String name : this.names) {
                if (name != null && Strings.hasText(name)) continue;
                validationException = ValidateActions.addValidationError("name is missing", validationException);
            }
        }
        return validationException;
    }

    public GetIndexTemplatesRequest names(String ... names) {
        this.names = names;
        return this;
    }

    public String[] names() {
        return this.names;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.names = in.readStringArray();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.names);
    }
}

