/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.search;

import conductor.org.elasticsearch.action.search.SearchPhaseContext;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.util.concurrent.CountDown;
import conductor.org.elasticsearch.search.SearchPhaseResult;
import conductor.org.elasticsearch.search.SearchShardTarget;
import java.util.function.Consumer;

final class CountedCollector<R extends SearchPhaseResult> {
    private final Consumer<R> resultConsumer;
    private final CountDown counter;
    private final Runnable onFinish;
    private final SearchPhaseContext context;

    CountedCollector(Consumer<R> resultConsumer, int expectedOps, Runnable onFinish, SearchPhaseContext context) {
        this.resultConsumer = resultConsumer;
        this.counter = new CountDown(expectedOps);
        this.onFinish = onFinish;
        this.context = context;
    }

    void countDown() {
        assert (!this.counter.isCountedDown()) : "more operations executed than specified";
        if (this.counter.countDown()) {
            this.onFinish.run();
        }
    }

    void onResult(R result) {
        try {
            this.resultConsumer.accept(result);
        }
        finally {
            this.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onFailure(int shardIndex, @Nullable SearchShardTarget shardTarget, Exception e) {
        try {
            this.context.onShardFailure(shardIndex, shardTarget, e);
        }
        finally {
            this.countDown();
        }
    }
}

