/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.support;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.logging.log4j.Logger;
import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.ActionRequest;
import conductor.org.elasticsearch.action.ActionResponse;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.TransportAction;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.tasks.Task;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportChannel;
import conductor.org.elasticsearch.transport.TransportRequest;
import conductor.org.elasticsearch.transport.TransportRequestHandler;
import conductor.org.elasticsearch.transport.TransportResponse;
import conductor.org.elasticsearch.transport.TransportService;
import java.util.function.Supplier;

public abstract class HandledTransportAction<Request extends ActionRequest, Response extends ActionResponse>
extends TransportAction<Request, Response> {
    protected HandledTransportAction(Settings settings, String actionName, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<Request> request) {
        this(settings, actionName, true, threadPool, transportService, actionFilters, indexNameExpressionResolver, request);
    }

    protected HandledTransportAction(Settings settings, String actionName, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<Request> requestReader, IndexNameExpressionResolver indexNameExpressionResolver) {
        this(settings, actionName, true, threadPool, transportService, actionFilters, requestReader, indexNameExpressionResolver);
    }

    protected HandledTransportAction(Settings settings, String actionName, boolean canTripCircuitBreaker, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<Request> request) {
        super(settings, actionName, threadPool, actionFilters, indexNameExpressionResolver, transportService.getTaskManager());
        transportService.registerRequestHandler(actionName, request, "same", false, canTripCircuitBreaker, new TransportHandler());
    }

    protected HandledTransportAction(Settings settings, String actionName, boolean canTripCircuitBreaker, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<Request> requestReader, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, actionName, threadPool, actionFilters, indexNameExpressionResolver, transportService.getTaskManager());
        transportService.registerRequestHandler(actionName, "same", false, canTripCircuitBreaker, requestReader, new TransportHandler());
    }

    public static final class ChannelActionListener<Response extends TransportResponse, Request extends TransportRequest>
    implements ActionListener<Response> {
        private final Logger logger = LogManager.getLogger(this.getClass());
        private final TransportChannel channel;
        private final Request request;
        private final String actionName;

        public ChannelActionListener(TransportChannel channel, String actionName, Request request) {
            this.channel = channel;
            this.request = request;
            this.actionName = actionName;
        }

        @Override
        public void onResponse(Response response) {
            try {
                this.channel.sendResponse((TransportResponse)response);
            }
            catch (Exception e) {
                this.onFailure(e);
            }
        }

        @Override
        public void onFailure(Exception e) {
            try {
                this.channel.sendResponse(e);
            }
            catch (Exception e1) {
                this.logger.warn(() -> new ParameterizedMessage("Failed to send error response for action [{}] and request [{}]", (Object)this.actionName, (Object)this.request), (Throwable)e1);
            }
        }
    }

    class TransportHandler
    implements TransportRequestHandler<Request> {
        TransportHandler() {
        }

        @Override
        public final void messageReceived(Request request, TransportChannel channel) throws Exception {
            throw new UnsupportedOperationException("the task parameter is required for this operation");
        }

        @Override
        public final void messageReceived(Request request, TransportChannel channel, Task task) throws Exception {
            Logger logger = HandledTransportAction.this.logger;
            HandledTransportAction.this.execute(task, request, new ChannelActionListener(channel, HandledTransportAction.this.actionName, request));
        }
    }
}

