/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client;

import conductor.org.elasticsearch.common.Nullable;
import java.util.ArrayList;
import java.util.List;

public class ValidationException
extends IllegalArgumentException {
    private final List<String> validationErrors = new ArrayList<String>();

    public void addValidationError(String error) {
        this.validationErrors.add(error);
    }

    public final void addValidationErrors(@Nullable ValidationException exception) {
        if (exception != null) {
            for (String error : exception.validationErrors()) {
                this.addValidationError(error);
            }
        }
    }

    public final List<String> validationErrors() {
        return this.validationErrors;
    }

    @Override
    public final String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Validation Failed: ");
        int index = 0;
        for (String error : this.validationErrors) {
            sb.append(++index).append(": ").append(error).append(";");
        }
        return sb.toString();
    }
}

