/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.ml.job.config;

import conductor.org.elasticsearch.client.ml.job.config.DefaultDetectorDescription;
import conductor.org.elasticsearch.client.ml.job.config.DetectionRule;
import conductor.org.elasticsearch.client.ml.job.config.DetectorFunction;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class Detector
implements ToXContentObject {
    public static final ParseField DETECTOR_DESCRIPTION_FIELD = new ParseField("detector_description", new String[0]);
    public static final ParseField FUNCTION_FIELD = new ParseField("function", new String[0]);
    public static final ParseField FIELD_NAME_FIELD = new ParseField("field_name", new String[0]);
    public static final ParseField BY_FIELD_NAME_FIELD = new ParseField("by_field_name", new String[0]);
    public static final ParseField OVER_FIELD_NAME_FIELD = new ParseField("over_field_name", new String[0]);
    public static final ParseField PARTITION_FIELD_NAME_FIELD = new ParseField("partition_field_name", new String[0]);
    public static final ParseField USE_NULL_FIELD = new ParseField("use_null", new String[0]);
    public static final ParseField EXCLUDE_FREQUENT_FIELD = new ParseField("exclude_frequent", new String[0]);
    public static final ParseField CUSTOM_RULES_FIELD = new ParseField("custom_rules", new String[0]);
    public static final ParseField DETECTOR_INDEX = new ParseField("detector_index", new String[0]);
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser("detector", true, Builder::new);
    private final String detectorDescription;
    private final DetectorFunction function;
    private final String fieldName;
    private final String byFieldName;
    private final String overFieldName;
    private final String partitionFieldName;
    private final boolean useNull;
    private final ExcludeFrequent excludeFrequent;
    private final List<DetectionRule> rules;
    private final int detectorIndex;

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DETECTOR_DESCRIPTION_FIELD.getPreferredName(), this.detectorDescription);
        builder.field(FUNCTION_FIELD.getPreferredName(), (Object)this.function);
        if (this.fieldName != null) {
            builder.field(FIELD_NAME_FIELD.getPreferredName(), this.fieldName);
        }
        if (this.byFieldName != null) {
            builder.field(BY_FIELD_NAME_FIELD.getPreferredName(), this.byFieldName);
        }
        if (this.overFieldName != null) {
            builder.field(OVER_FIELD_NAME_FIELD.getPreferredName(), this.overFieldName);
        }
        if (this.partitionFieldName != null) {
            builder.field(PARTITION_FIELD_NAME_FIELD.getPreferredName(), this.partitionFieldName);
        }
        if (this.useNull) {
            builder.field(USE_NULL_FIELD.getPreferredName(), this.useNull);
        }
        if (this.excludeFrequent != null) {
            builder.field(EXCLUDE_FREQUENT_FIELD.getPreferredName(), (Object)this.excludeFrequent);
        }
        if (!this.rules.isEmpty()) {
            builder.field(CUSTOM_RULES_FIELD.getPreferredName(), this.rules);
        }
        if (this.detectorIndex >= 0) {
            builder.field(DETECTOR_INDEX.getPreferredName(), this.detectorIndex);
        }
        builder.endObject();
        return builder;
    }

    private Detector(String detectorDescription, DetectorFunction function, String fieldName, String byFieldName, String overFieldName, String partitionFieldName, boolean useNull, ExcludeFrequent excludeFrequent, List<DetectionRule> rules, int detectorIndex) {
        this.function = function;
        this.fieldName = fieldName;
        this.byFieldName = byFieldName;
        this.overFieldName = overFieldName;
        this.partitionFieldName = partitionFieldName;
        this.useNull = useNull;
        this.excludeFrequent = excludeFrequent;
        this.rules = Collections.unmodifiableList(rules);
        this.detectorDescription = detectorDescription != null ? detectorDescription : DefaultDetectorDescription.of(this);
        this.detectorIndex = detectorIndex;
    }

    public String getDetectorDescription() {
        return this.detectorDescription;
    }

    public DetectorFunction getFunction() {
        return this.function;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getByFieldName() {
        return this.byFieldName;
    }

    public String getOverFieldName() {
        return this.overFieldName;
    }

    public String getPartitionFieldName() {
        return this.partitionFieldName;
    }

    public boolean isUseNull() {
        return this.useNull;
    }

    public ExcludeFrequent getExcludeFrequent() {
        return this.excludeFrequent;
    }

    public List<DetectionRule> getRules() {
        return this.rules;
    }

    public int getDetectorIndex() {
        return this.detectorIndex;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Detector)) {
            return false;
        }
        Detector that = (Detector)other;
        return Objects.equals(this.detectorDescription, that.detectorDescription) && Objects.equals((Object)this.function, (Object)that.function) && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.byFieldName, that.byFieldName) && Objects.equals(this.overFieldName, that.overFieldName) && Objects.equals(this.partitionFieldName, that.partitionFieldName) && Objects.equals(this.useNull, that.useNull) && Objects.equals((Object)this.excludeFrequent, (Object)that.excludeFrequent) && Objects.equals(this.rules, that.rules) && this.detectorIndex == that.detectorIndex;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.detectorDescription, this.function, this.fieldName, this.byFieldName, this.overFieldName, this.partitionFieldName, this.useNull, this.excludeFrequent, this.rules, this.detectorIndex});
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        PARSER.declareString(Builder::setDetectorDescription, DETECTOR_DESCRIPTION_FIELD);
        PARSER.declareString(Builder::setFunction, FUNCTION_FIELD);
        PARSER.declareString(Builder::setFieldName, FIELD_NAME_FIELD);
        PARSER.declareString(Builder::setByFieldName, BY_FIELD_NAME_FIELD);
        PARSER.declareString(Builder::setOverFieldName, OVER_FIELD_NAME_FIELD);
        PARSER.declareString(Builder::setPartitionFieldName, PARTITION_FIELD_NAME_FIELD);
        PARSER.declareBoolean(Builder::setUseNull, USE_NULL_FIELD);
        PARSER.declareField(Builder::setExcludeFrequent, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return ExcludeFrequent.forString(p.text());
            }
            throw new IllegalArgumentException("Unsupported token [" + (Object)((Object)p.currentToken()) + "]");
        }, EXCLUDE_FREQUENT_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareObjectArray(Builder::setRules, (p, c) -> DetectionRule.PARSER.apply(p, (Void)c).build(), CUSTOM_RULES_FIELD);
        PARSER.declareInt(Builder::setDetectorIndex, DETECTOR_INDEX);
    }

    public static class Builder {
        private String detectorDescription;
        private DetectorFunction function;
        private String fieldName;
        private String byFieldName;
        private String overFieldName;
        private String partitionFieldName;
        private boolean useNull = false;
        private ExcludeFrequent excludeFrequent;
        private List<DetectionRule> rules = Collections.emptyList();
        private int detectorIndex = -1;

        public Builder() {
        }

        public Builder(Detector detector) {
            this.detectorDescription = detector.detectorDescription;
            this.function = detector.function;
            this.fieldName = detector.fieldName;
            this.byFieldName = detector.byFieldName;
            this.overFieldName = detector.overFieldName;
            this.partitionFieldName = detector.partitionFieldName;
            this.useNull = detector.useNull;
            this.excludeFrequent = detector.excludeFrequent;
            this.rules = new ArrayList<DetectionRule>(detector.rules);
            this.detectorIndex = detector.detectorIndex;
        }

        public Builder(String function, String fieldName) {
            this(DetectorFunction.fromString(function), fieldName);
        }

        public Builder(DetectorFunction function, String fieldName) {
            this.function = function;
            this.fieldName = fieldName;
        }

        public Builder setDetectorDescription(String detectorDescription) {
            this.detectorDescription = detectorDescription;
            return this;
        }

        public Builder setFunction(String function) {
            this.function = DetectorFunction.fromString(function);
            return this;
        }

        public Builder setFieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder setByFieldName(String byFieldName) {
            this.byFieldName = byFieldName;
            return this;
        }

        public Builder setOverFieldName(String overFieldName) {
            this.overFieldName = overFieldName;
            return this;
        }

        public Builder setPartitionFieldName(String partitionFieldName) {
            this.partitionFieldName = partitionFieldName;
            return this;
        }

        public Builder setUseNull(boolean useNull) {
            this.useNull = useNull;
            return this;
        }

        public Builder setExcludeFrequent(ExcludeFrequent excludeFrequent) {
            this.excludeFrequent = excludeFrequent;
            return this;
        }

        public Builder setRules(List<DetectionRule> rules) {
            this.rules = rules;
            return this;
        }

        public Builder setDetectorIndex(int detectorIndex) {
            this.detectorIndex = detectorIndex;
            return this;
        }

        public Detector build() {
            return new Detector(this.detectorDescription, this.function, this.fieldName, this.byFieldName, this.overFieldName, this.partitionFieldName, this.useNull, this.excludeFrequent, this.rules, this.detectorIndex);
        }
    }

    public static enum ExcludeFrequent {
        ALL,
        NONE,
        BY,
        OVER;


        public static ExcludeFrequent forString(String value) {
            return ExcludeFrequent.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

