/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.ml.job.config;

import conductor.org.elasticsearch.common.ParseField;
import java.util.Locale;

public enum Operator {
    GT{

        @Override
        public boolean test(double lhs, double rhs) {
            return Double.compare(lhs, rhs) > 0;
        }
    }
    ,
    GTE{

        @Override
        public boolean test(double lhs, double rhs) {
            return Double.compare(lhs, rhs) >= 0;
        }
    }
    ,
    LT{

        @Override
        public boolean test(double lhs, double rhs) {
            return Double.compare(lhs, rhs) < 0;
        }
    }
    ,
    LTE{

        @Override
        public boolean test(double lhs, double rhs) {
            return Double.compare(lhs, rhs) <= 0;
        }
    };

    public static final ParseField OPERATOR_FIELD;

    public boolean test(double lhs, double rhs) {
        return false;
    }

    public static Operator fromString(String name) {
        return Operator.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    static {
        OPERATOR_FIELD = new ParseField("operator", new String[0]);
    }
}

