/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.query;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.client.Client;
import conductor.org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import conductor.org.elasticsearch.common.util.concurrent.CountDown;
import conductor.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import conductor.org.elasticsearch.index.query.QueryShardContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.LongSupplier;

public class QueryRewriteContext {
    private final NamedXContentRegistry xContentRegistry;
    private final NamedWriteableRegistry writeableRegistry;
    protected final Client client;
    protected final LongSupplier nowInMillis;
    private final List<BiConsumer<Client, ActionListener<?>>> asyncActions = new ArrayList();

    public QueryRewriteContext(NamedXContentRegistry xContentRegistry, NamedWriteableRegistry writeableRegistry, Client client, LongSupplier nowInMillis) {
        this.xContentRegistry = xContentRegistry;
        this.writeableRegistry = writeableRegistry;
        this.client = client;
        this.nowInMillis = nowInMillis;
    }

    public NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    public long nowInMillis() {
        return this.nowInMillis.getAsLong();
    }

    public NamedWriteableRegistry getWriteableRegistry() {
        return this.writeableRegistry;
    }

    public QueryShardContext convertToShardContext() {
        return null;
    }

    public void registerAsyncAction(BiConsumer<Client, ActionListener<?>> asyncAction) {
        this.asyncActions.add(asyncAction);
    }

    public boolean hasAsyncActions() {
        return !this.asyncActions.isEmpty();
    }

    public void executeAsyncActions(final ActionListener listener) {
        if (this.asyncActions.isEmpty()) {
            listener.onResponse(null);
        } else {
            final CountDown countDown = new CountDown(this.asyncActions.size());
            ActionListener internalListener = new ActionListener(){

                public void onResponse(Object o) {
                    if (countDown.countDown()) {
                        listener.onResponse(null);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    if (countDown.fastForward()) {
                        listener.onFailure(e);
                    }
                }
            };
            ArrayList biConsumers = new ArrayList(this.asyncActions);
            this.asyncActions.clear();
            for (BiConsumer biConsumer : biConsumers) {
                biConsumer.accept(this.client, internalListener);
            }
        }
    }

    public boolean convertNowRangeToMatchAll() {
        return false;
    }
}

