/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.monitor;

import conductor.org.elasticsearch.cluster.ClusterInfoService;
import conductor.org.elasticsearch.common.component.AbstractLifecycleComponent;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.env.NodeEnvironment;
import conductor.org.elasticsearch.monitor.fs.FsService;
import conductor.org.elasticsearch.monitor.jvm.JvmGcMonitorService;
import conductor.org.elasticsearch.monitor.jvm.JvmService;
import conductor.org.elasticsearch.monitor.os.OsService;
import conductor.org.elasticsearch.monitor.process.ProcessService;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import java.io.IOException;

public class MonitorService
extends AbstractLifecycleComponent {
    private final JvmGcMonitorService jvmGcMonitorService;
    private final OsService osService;
    private final ProcessService processService;
    private final JvmService jvmService;
    private final FsService fsService;

    public MonitorService(Settings settings, NodeEnvironment nodeEnvironment, ThreadPool threadPool, ClusterInfoService clusterInfoService) throws IOException {
        super(settings);
        this.jvmGcMonitorService = new JvmGcMonitorService(settings, threadPool);
        this.osService = new OsService(settings);
        this.processService = new ProcessService(settings);
        this.jvmService = new JvmService(settings);
        this.fsService = new FsService(settings, nodeEnvironment, clusterInfoService);
    }

    public OsService osService() {
        return this.osService;
    }

    public ProcessService processService() {
        return this.processService;
    }

    public JvmService jvmService() {
        return this.jvmService;
    }

    public FsService fsService() {
        return this.fsService;
    }

    @Override
    protected void doStart() {
        this.jvmGcMonitorService.start();
    }

    @Override
    protected void doStop() {
        this.jvmGcMonitorService.stop();
    }

    @Override
    protected void doClose() {
        this.jvmGcMonitorService.close();
    }
}

