/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.plugins;

import conductor.org.apache.lucene.analysis.Analyzer;
import conductor.org.apache.lucene.analysis.hunspell.Dictionary;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.env.Environment;
import conductor.org.elasticsearch.index.IndexSettings;
import conductor.org.elasticsearch.index.analysis.AnalyzerProvider;
import conductor.org.elasticsearch.index.analysis.CharFilterFactory;
import conductor.org.elasticsearch.index.analysis.PreBuiltAnalyzerProviderFactory;
import conductor.org.elasticsearch.index.analysis.PreConfiguredCharFilter;
import conductor.org.elasticsearch.index.analysis.PreConfiguredTokenFilter;
import conductor.org.elasticsearch.index.analysis.PreConfiguredTokenizer;
import conductor.org.elasticsearch.index.analysis.TokenFilterFactory;
import conductor.org.elasticsearch.index.analysis.TokenizerFactory;
import conductor.org.elasticsearch.indices.analysis.AnalysisModule;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public interface AnalysisPlugin {
    default public Map<String, AnalysisModule.AnalysisProvider<CharFilterFactory>> getCharFilters() {
        return Collections.emptyMap();
    }

    default public Map<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> getTokenFilters() {
        return Collections.emptyMap();
    }

    default public Map<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> getTokenizers() {
        return Collections.emptyMap();
    }

    default public Map<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<? extends Analyzer>>> getAnalyzers() {
        return Collections.emptyMap();
    }

    default public List<PreBuiltAnalyzerProviderFactory> getPreBuiltAnalyzerProviderFactories() {
        return Collections.emptyList();
    }

    default public List<PreConfiguredCharFilter> getPreConfiguredCharFilters() {
        return Collections.emptyList();
    }

    default public List<PreConfiguredTokenFilter> getPreConfiguredTokenFilters() {
        return Collections.emptyList();
    }

    default public List<PreConfiguredTokenizer> getPreConfiguredTokenizers() {
        return Collections.emptyList();
    }

    default public Map<String, Dictionary> getHunspellDictionaries() {
        return Collections.emptyMap();
    }

    @Deprecated
    public static <T> AnalysisModule.AnalysisProvider<T> requriesAnalysisSettings(AnalysisModule.AnalysisProvider<T> provider) {
        return AnalysisPlugin.requiresAnalysisSettings(provider);
    }

    public static <T> AnalysisModule.AnalysisProvider<T> requiresAnalysisSettings(final AnalysisModule.AnalysisProvider<T> provider) {
        return new AnalysisModule.AnalysisProvider<T>(){

            @Override
            public T get(IndexSettings indexSettings, Environment environment, String name, Settings settings) throws IOException {
                return provider.get(indexSettings, environment, name, settings);
            }

            @Override
            public boolean requiresAnalysisSettings() {
                return true;
            }
        };
    }
}

