/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.repositories;

import conductor.org.apache.lucene.index.IndexCommit;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.cluster.metadata.IndexMetaData;
import conductor.org.elasticsearch.cluster.metadata.MetaData;
import conductor.org.elasticsearch.cluster.metadata.RepositoryMetaData;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.common.component.LifecycleComponent;
import conductor.org.elasticsearch.index.shard.IndexShard;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import conductor.org.elasticsearch.index.store.Store;
import conductor.org.elasticsearch.indices.recovery.RecoveryState;
import conductor.org.elasticsearch.repositories.IndexId;
import conductor.org.elasticsearch.repositories.RepositoryData;
import conductor.org.elasticsearch.snapshots.SnapshotId;
import conductor.org.elasticsearch.snapshots.SnapshotInfo;
import conductor.org.elasticsearch.snapshots.SnapshotShardFailure;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;

public interface Repository
extends LifecycleComponent {
    public RepositoryMetaData getMetadata();

    public SnapshotInfo getSnapshotInfo(SnapshotId var1);

    public MetaData getSnapshotGlobalMetaData(SnapshotId var1);

    public IndexMetaData getSnapshotIndexMetaData(SnapshotId var1, IndexId var2) throws IOException;

    public RepositoryData getRepositoryData();

    public void initializeSnapshot(SnapshotId var1, List<IndexId> var2, MetaData var3);

    public SnapshotInfo finalizeSnapshot(SnapshotId var1, List<IndexId> var2, long var3, String var5, int var6, List<SnapshotShardFailure> var7, long var8, boolean var10);

    public void deleteSnapshot(SnapshotId var1, long var2);

    public long getSnapshotThrottleTimeInNanos();

    public long getRestoreThrottleTimeInNanos();

    public String startVerification();

    public void endVerification(String var1);

    public void verify(String var1, DiscoveryNode var2);

    public boolean isReadOnly();

    public void snapshotShard(IndexShard var1, Store var2, SnapshotId var3, IndexId var4, IndexCommit var5, IndexShardSnapshotStatus var6);

    public void restoreShard(IndexShard var1, SnapshotId var2, Version var3, IndexId var4, ShardId var5, RecoveryState var6);

    public IndexShardSnapshotStatus getShardSnapshotStatus(SnapshotId var1, Version var2, IndexId var3, ShardId var4);

    public static interface Factory {
        public Repository create(RepositoryMetaData var1) throws Exception;

        default public Repository create(RepositoryMetaData metaData, Function<String, Factory> typeLookup) throws Exception {
            return this.create(metaData);
        }
    }
}

