/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.rest.action.admin.indices;

import conductor.org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import conductor.org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import conductor.org.elasticsearch.action.support.IndicesOptions;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.RestChannel;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.action.RestToXContentListener;
import java.io.IOException;

public class RestGetSettingsAction
extends BaseRestHandler {
    public RestGetSettingsAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_settings", this);
        controller.registerHandler(RestRequest.Method.GET, "/_settings/{name}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_settings", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_settings/{name}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_setting/{name}", this);
    }

    @Override
    public String getName() {
        return "get_settings_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] names = request.paramAsStringArrayOrEmptyIfAll("name");
        boolean renderDefaults = request.paramAsBoolean("include_defaults", false);
        request.paramAsBoolean("flat_settings", false);
        GetSettingsRequest getSettingsRequest = new GetSettingsRequest().indices(Strings.splitStringByCommaToArray(request.param("index"))).indicesOptions(IndicesOptions.fromRequest(request, IndicesOptions.strictExpandOpen())).humanReadable(request.hasParam("human")).includeDefaults(renderDefaults).names(names);
        getSettingsRequest.local(request.paramAsBoolean("local", getSettingsRequest.local()));
        getSettingsRequest.masterNodeTimeout(request.paramAsTime("master_timeout", getSettingsRequest.masterNodeTimeout()));
        return channel -> client.admin().indices().getSettings(getSettingsRequest, new RestToXContentListener<GetSettingsResponse>((RestChannel)channel));
    }
}

