/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.script;

import conductor.org.elasticsearch.common.settings.ClusterSettings;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.plugins.ScriptPlugin;
import conductor.org.elasticsearch.script.BucketAggregationScript;
import conductor.org.elasticsearch.script.BucketAggregationSelectorScript;
import conductor.org.elasticsearch.script.FilterScript;
import conductor.org.elasticsearch.script.IngestConditionalScript;
import conductor.org.elasticsearch.script.IngestScript;
import conductor.org.elasticsearch.script.ScoreScript;
import conductor.org.elasticsearch.script.ScriptContext;
import conductor.org.elasticsearch.script.ScriptEngine;
import conductor.org.elasticsearch.script.ScriptService;
import conductor.org.elasticsearch.script.ScriptedMetricAggContexts;
import conductor.org.elasticsearch.script.SearchScript;
import conductor.org.elasticsearch.script.SignificantTermsHeuristicScoreScript;
import conductor.org.elasticsearch.script.SimilarityScript;
import conductor.org.elasticsearch.script.SimilarityWeightScript;
import conductor.org.elasticsearch.script.TemplateScript;
import conductor.org.elasticsearch.script.TermsSetQueryScript;
import conductor.org.elasticsearch.script.UpdateScript;
import conductor.org.elasticsearch.search.aggregations.pipeline.movfn.MovingFunctionScript;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ScriptModule {
    public static final Map<String, ScriptContext<?>> CORE_CONTEXTS = Stream.of(SearchScript.CONTEXT, SearchScript.AGGS_CONTEXT, ScoreScript.CONTEXT, SearchScript.SCRIPT_SORT_CONTEXT, TermsSetQueryScript.CONTEXT, UpdateScript.CONTEXT, BucketAggregationScript.CONTEXT, BucketAggregationSelectorScript.CONTEXT, SignificantTermsHeuristicScoreScript.CONTEXT, IngestScript.CONTEXT, IngestConditionalScript.CONTEXT, FilterScript.CONTEXT, SimilarityScript.CONTEXT, SimilarityWeightScript.CONTEXT, TemplateScript.CONTEXT, MovingFunctionScript.CONTEXT, ScriptedMetricAggContexts.InitScript.CONTEXT, ScriptedMetricAggContexts.MapScript.CONTEXT, ScriptedMetricAggContexts.CombineScript.CONTEXT, ScriptedMetricAggContexts.ReduceScript.CONTEXT).collect(Collectors.toMap(c -> c.name, Function.identity()));
    private final ScriptService scriptService;

    public ScriptModule(Settings settings, List<ScriptPlugin> scriptPlugins) {
        HashMap<String, ScriptEngine> engines = new HashMap<String, ScriptEngine>();
        HashMap contexts = new HashMap(CORE_CONTEXTS);
        for (ScriptPlugin plugin : scriptPlugins) {
            for (ScriptContext<?> context : plugin.getContexts()) {
                ScriptContext<?> oldContext = contexts.put(context.name, context);
                if (oldContext == null) continue;
                throw new IllegalArgumentException("Context name [" + context.name + "] defined twice");
            }
        }
        for (ScriptPlugin plugin : scriptPlugins) {
            ScriptEngine existing;
            ScriptEngine engine = plugin.getScriptEngine(settings, contexts.values());
            if (engine == null || (existing = engines.put(engine.getType(), engine)) == null) continue;
            throw new IllegalArgumentException("scripting language [" + engine.getType() + "] defined for engine [" + existing.getClass().getName() + "] and [" + engine.getClass().getName());
        }
        this.scriptService = new ScriptService(settings, Collections.unmodifiableMap(engines), Collections.unmodifiableMap(contexts));
    }

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    public void registerClusterSettingsListeners(ClusterSettings clusterSettings) {
        this.scriptService.registerClusterSettingsListeners(clusterSettings);
    }
}

