/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.profile.aggregation;

import conductor.org.elasticsearch.search.aggregations.Aggregator;
import conductor.org.elasticsearch.search.profile.AbstractProfiler;
import conductor.org.elasticsearch.search.profile.aggregation.AggregationProfileBreakdown;
import conductor.org.elasticsearch.search.profile.aggregation.InternalAggregationProfileTree;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AggregationProfiler
extends AbstractProfiler<AggregationProfileBreakdown, Aggregator> {
    private final Map<List<String>, AggregationProfileBreakdown> profileBrakdownLookup = new HashMap<List<String>, AggregationProfileBreakdown>();

    public AggregationProfiler() {
        super(new InternalAggregationProfileTree());
    }

    @Override
    public AggregationProfileBreakdown getQueryBreakdown(Aggregator agg) {
        List<String> path = AggregationProfiler.getAggregatorPath(agg);
        AggregationProfileBreakdown aggregationProfileBreakdown = this.profileBrakdownLookup.get(path);
        if (aggregationProfileBreakdown == null) {
            aggregationProfileBreakdown = (AggregationProfileBreakdown)super.getQueryBreakdown(agg);
            this.profileBrakdownLookup.put(path, aggregationProfileBreakdown);
        }
        return aggregationProfileBreakdown;
    }

    public static List<String> getAggregatorPath(Aggregator agg) {
        LinkedList<String> path = new LinkedList<String>();
        while (agg != null) {
            path.addFirst(agg.name());
            agg = agg.parent();
        }
        return path;
    }
}

