/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.document;

import conductor.org.apache.lucene.document.Field;
import conductor.org.apache.lucene.document.FieldType;
import conductor.org.apache.lucene.document.SortedSetDocValuesRangeQuery;
import conductor.org.apache.lucene.index.DocValues;
import conductor.org.apache.lucene.index.DocValuesType;
import conductor.org.apache.lucene.index.LeafReader;
import conductor.org.apache.lucene.index.SortedSetDocValues;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.util.BytesRef;
import java.io.IOException;

public class SortedDocValuesField
extends Field {
    public static final FieldType TYPE = new FieldType();

    public SortedDocValuesField(String name, BytesRef bytes) {
        super(name, TYPE);
        this.fieldsData = bytes;
    }

    public static Query newSlowRangeQuery(String field, BytesRef lowerValue, BytesRef upperValue, boolean lowerInclusive, boolean upperInclusive) {
        return new SortedSetDocValuesRangeQuery(field, lowerValue, upperValue, lowerInclusive, upperInclusive){

            @Override
            SortedSetDocValues getValues(LeafReader reader, String field) throws IOException {
                return DocValues.singleton(DocValues.getSorted(reader, field));
            }
        };
    }

    public static Query newSlowExactQuery(String field, BytesRef value) {
        return SortedDocValuesField.newSlowRangeQuery(field, value, value, true, true);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.SORTED);
        TYPE.freeze();
    }
}

