/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.queries.function.valuesource;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.queries.function.FunctionValues;
import conductor.org.apache.lucene.queries.function.ValueSource;
import conductor.org.apache.lucene.queries.function.docvalues.FloatDocValues;
import conductor.org.apache.lucene.queries.function.valuesource.IDFValueSource;
import conductor.org.apache.lucene.search.CollectionStatistics;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.TermStatistics;
import conductor.org.apache.lucene.search.similarities.Similarity;
import conductor.org.apache.lucene.search.similarities.TFIDFSimilarity;
import conductor.org.apache.lucene.util.BytesRef;
import java.io.IOException;
import java.util.Map;

public class NormValueSource
extends ValueSource {
    protected final String field;

    public NormValueSource(String field) {
        this.field = field;
    }

    public String name() {
        return "norm";
    }

    @Override
    public String description() {
        return this.name() + '(' + this.field + ')';
    }

    @Override
    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
        context.put("searcher", searcher);
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        IndexSearcher searcher = (IndexSearcher)context.get("searcher");
        TFIDFSimilarity similarity = IDFValueSource.asTFIDF(searcher.getSimilarity(true), this.field);
        if (similarity == null) {
            throw new UnsupportedOperationException("requires a TFIDFSimilarity (such as ClassicSimilarity)");
        }
        Similarity.SimWeight simWeight = similarity.computeWeight(1.0f, new CollectionStatistics(this.field, 1L, 1L, 1L, 1L), new TermStatistics(new BytesRef("bogus"), 1L, 1L));
        final Similarity.SimScorer simScorer = similarity.simScorer(simWeight, readerContext);
        return new FloatDocValues(this){
            int lastDocID;
            {
                super(vs);
                this.lastDocID = -1;
            }

            @Override
            public float floatVal(int docID) throws IOException {
                if (docID < this.lastDocID) {
                    throw new AssertionError((Object)("docs out of order: lastDocID=" + this.lastDocID + " docID=" + docID));
                }
                this.lastDocID = docID;
                return simScorer.score(docID, 1.0f);
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        return this.field.equals(((NormValueSource)o).field);
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() + this.field.hashCode();
    }
}

