/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.transport.TransportException;
import conductor.org.elasticsearch.transport.TransportResponse;
import conductor.org.elasticsearch.transport.TransportResponseHandler;
import java.util.Objects;
import java.util.function.Supplier;

public class ActionListenerResponseHandler<Response extends TransportResponse>
implements TransportResponseHandler<Response> {
    private final ActionListener<? super Response> listener;
    private final Supplier<Response> responseSupplier;

    public ActionListenerResponseHandler(ActionListener<? super Response> listener, Supplier<Response> responseSupplier) {
        this.listener = Objects.requireNonNull(listener);
        this.responseSupplier = Objects.requireNonNull(responseSupplier);
    }

    @Override
    public void handleResponse(Response response) {
        this.listener.onResponse(response);
    }

    @Override
    public void handleException(TransportException e) {
        this.listener.onFailure(e);
    }

    @Override
    public Response newInstance() {
        return (Response)((TransportResponse)this.responseSupplier.get());
    }

    @Override
    public String executor() {
        return "same";
    }
}

