/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.cluster;

import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import java.util.function.Predicate;

public final class MasterNodeChangePredicate {
    private MasterNodeChangePredicate() {
    }

    public static Predicate<ClusterState> build(ClusterState currentState) {
        long currentVersion = currentState.version();
        DiscoveryNode masterNode = currentState.nodes().getMasterNode();
        String currentMasterId = masterNode == null ? null : masterNode.getEphemeralId();
        return newState -> {
            DiscoveryNode newMaster = newState.nodes().getMasterNode();
            boolean accept = newMaster == null ? false : (!newMaster.getEphemeralId().equals(currentMasterId) ? true : newState.version() > currentVersion);
            return accept;
        };
    }
}

