/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.reindex;

import conductor.org.apache.logging.log4j.Logger;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.delete.DeleteRequest;
import conductor.org.elasticsearch.client.ParentTaskAssigningClient;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.index.reindex.AbstractAsyncBulkByScrollAction;
import conductor.org.elasticsearch.index.reindex.BulkByScrollResponse;
import conductor.org.elasticsearch.index.reindex.BulkByScrollTask;
import conductor.org.elasticsearch.index.reindex.DeleteByQueryRequest;
import conductor.org.elasticsearch.index.reindex.ScrollableHitSource;
import conductor.org.elasticsearch.script.ScriptService;
import conductor.org.elasticsearch.threadpool.ThreadPool;

public class AsyncDeleteByQueryAction
extends AbstractAsyncBulkByScrollAction<DeleteByQueryRequest> {
    public AsyncDeleteByQueryAction(BulkByScrollTask task, Logger logger, ParentTaskAssigningClient client, ThreadPool threadPool, DeleteByQueryRequest request, ScriptService scriptService, ClusterState clusterState, ActionListener<BulkByScrollResponse> listener) {
        super(task, logger, client, threadPool, request, scriptService, clusterState, listener);
    }

    @Override
    protected boolean needsSourceDocumentVersions() {
        return true;
    }

    @Override
    protected boolean accept(ScrollableHitSource.Hit doc) {
        return true;
    }

    @Override
    protected AbstractAsyncBulkByScrollAction.RequestWrapper<DeleteRequest> buildRequest(ScrollableHitSource.Hit doc) {
        DeleteRequest delete = new DeleteRequest();
        delete.index(doc.getIndex());
        delete.type(doc.getType());
        delete.id(doc.getId());
        delete.version(doc.getVersion());
        return AsyncDeleteByQueryAction.wrap(delete);
    }

    @Override
    protected AbstractAsyncBulkByScrollAction.RequestWrapper<?> copyMetadata(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, ScrollableHitSource.Hit doc) {
        request.setParent(doc.getParent());
        request.setRouting(doc.getRouting());
        return request;
    }
}

