/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.reindex.remote;

import conductor.org.apache.http.entity.ContentType;
import conductor.org.apache.http.nio.entity.NStringEntity;
import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.search.SearchRequest;
import conductor.org.elasticsearch.client.Request;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.unit.TimeValue;
import conductor.org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import conductor.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentHelper;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.json.JsonXContent;
import conductor.org.elasticsearch.search.sort.FieldSortBuilder;
import conductor.org.elasticsearch.search.sort.SortBuilder;
import java.io.IOException;

final class RemoteRequestBuilders {
    private RemoteRequestBuilders() {
    }

    static Request initialSearch(SearchRequest searchRequest, BytesReference query, Version remoteVersion) {
        StringBuilder path = new StringBuilder("/");
        RemoteRequestBuilders.addIndexesOrTypes(path, "Index", searchRequest.indices());
        RemoteRequestBuilders.addIndexesOrTypes(path, "Type", searchRequest.types());
        path.append("_search");
        Request request = new Request("POST", path.toString());
        if (searchRequest.scroll() != null) {
            TimeValue keepAlive = searchRequest.scroll().keepAlive();
            if (remoteVersion.before(Version.V_5_0_0)) {
                keepAlive = TimeValue.timeValueMillis((long)Math.ceil(keepAlive.millisFrac()));
            }
            request.addParameter("scroll", keepAlive.getStringRep());
        }
        request.addParameter("size", Integer.toString(searchRequest.source().size()));
        if (searchRequest.source().version() == null || searchRequest.source().version().booleanValue()) {
            request.addParameter("version", null);
        }
        if (searchRequest.source().sorts() != null) {
            boolean useScan = false;
            if (remoteVersion.before(Version.fromId(2010099))) {
                for (SortBuilder<?> sort : searchRequest.source().sorts()) {
                    FieldSortBuilder f;
                    if (!(sort instanceof FieldSortBuilder) || !(f = (FieldSortBuilder)sort).getFieldName().equals("_doc")) continue;
                    useScan = true;
                    break;
                }
            }
            if (useScan) {
                request.addParameter("search_type", "scan");
            } else {
                StringBuilder sorts = new StringBuilder(RemoteRequestBuilders.sortToUri(searchRequest.source().sorts().get(0)));
                for (int i = 1; i < searchRequest.source().sorts().size(); ++i) {
                    sorts.append(',').append(RemoteRequestBuilders.sortToUri(searchRequest.source().sorts().get(i)));
                }
                request.addParameter("sort", sorts.toString());
            }
        }
        if (remoteVersion.before(Version.fromId(2000099))) {
            searchRequest.source().storedField("_parent").storedField("_routing").storedField("_ttl");
            if (remoteVersion.before(Version.fromId(1000099)) && !searchRequest.source().storedFields().fieldNames().contains("_source")) {
                searchRequest.source().storedField("_source");
            }
        }
        if (searchRequest.source().storedFields() != null && !searchRequest.source().storedFields().fieldNames().isEmpty()) {
            StringBuilder fields = new StringBuilder(searchRequest.source().storedFields().fieldNames().get(0));
            for (int i = 1; i < searchRequest.source().storedFields().fieldNames().size(); ++i) {
                fields.append(',').append(searchRequest.source().storedFields().fieldNames().get(i));
            }
            String storedFieldsParamName = remoteVersion.before(Version.V_5_0_0_alpha4) ? "fields" : "stored_fields";
            request.addParameter(storedFieldsParamName, fields.toString());
        }
        try (XContentBuilder entity = JsonXContent.contentBuilder();
             XContentParser queryParser = XContentHelper.createParser(NamedXContentRegistry.EMPTY, LoggingDeprecationHandler.INSTANCE, query);){
            entity.startObject();
            entity.field("query");
            entity.copyCurrentStructure(queryParser);
            XContentParser.Token shouldBeEof = queryParser.nextToken();
            if (shouldBeEof != null) {
                throw new ElasticsearchException("query was more than a single object. This first token after the object is [" + (Object)((Object)shouldBeEof) + "]", new Object[0]);
            }
            if (searchRequest.source().fetchSource() != null) {
                entity.field("_source", searchRequest.source().fetchSource());
            } else if (remoteVersion.onOrAfter(Version.fromId(1000099))) {
                entity.field("_source", true);
            }
            entity.endObject();
            request.setJsonEntity(Strings.toString(entity));
        }
        catch (IOException e) {
            throw new ElasticsearchException("unexpected error building entity", (Throwable)e, new Object[0]);
        }
        return request;
    }

    private static void addIndexesOrTypes(StringBuilder path, String name, String[] indicesOrTypes) {
        if (indicesOrTypes == null || indicesOrTypes.length == 0) {
            return;
        }
        for (String indexOrType : indicesOrTypes) {
            RemoteRequestBuilders.checkIndexOrType(name, indexOrType);
        }
        path.append(Strings.arrayToCommaDelimitedString(indicesOrTypes)).append('/');
    }

    private static void checkIndexOrType(String name, String indexOrType) {
        if (indexOrType.indexOf(44) >= 0) {
            throw new IllegalArgumentException(name + " containing [,] not supported but got [" + indexOrType + "]");
        }
        if (indexOrType.indexOf(47) >= 0) {
            throw new IllegalArgumentException(name + " containing [/] not supported but got [" + indexOrType + "]");
        }
    }

    private static String sortToUri(SortBuilder<?> sort) {
        if (sort instanceof FieldSortBuilder) {
            FieldSortBuilder f = (FieldSortBuilder)sort;
            return f.getFieldName() + ":" + f.order();
        }
        throw new IllegalArgumentException("Unsupported sort [" + sort + "]");
    }

    static Request scroll(String scroll, TimeValue keepAlive, Version remoteVersion) {
        Request request = new Request("POST", "/_search/scroll");
        if (remoteVersion.before(Version.V_5_0_0)) {
            keepAlive = TimeValue.timeValueMillis((long)Math.ceil(keepAlive.millisFrac()));
        }
        request.addParameter("scroll", keepAlive.getStringRep());
        if (remoteVersion.before(Version.fromId(2000099))) {
            request.setEntity(new NStringEntity(scroll, ContentType.TEXT_PLAIN));
            return request;
        }
        try (XContentBuilder entity = JsonXContent.contentBuilder();){
            entity.startObject().field("scroll_id", scroll).endObject();
            request.setJsonEntity(Strings.toString(entity));
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to build scroll entity", (Throwable)e, new Object[0]);
        }
        return request;
    }

    static Request clearScroll(String scroll, Version remoteVersion) {
        Request request = new Request("DELETE", "/_search/scroll");
        if (remoteVersion.before(Version.fromId(2000099))) {
            request.setEntity(new NStringEntity(scroll, ContentType.TEXT_PLAIN));
            return request;
        }
        try (XContentBuilder entity = JsonXContent.contentBuilder();){
            entity.startObject().array("scroll_id", scroll).endObject();
            request.setJsonEntity(Strings.toString(entity));
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to build clear scroll entity", (Throwable)e, new Object[0]);
        }
        return request;
    }
}

