/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.bucket.range;

import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.search.aggregations.bucket.range.ParsedRange;
import conductor.org.joda.time.DateTime;
import conductor.org.joda.time.DateTimeZone;
import java.io.IOException;

public class ParsedDateRange
extends ParsedRange {
    private static ObjectParser<ParsedDateRange, Void> PARSER = new ObjectParser(ParsedDateRange.class.getSimpleName(), true, ParsedDateRange::new);

    @Override
    public String getType() {
        return "date_range";
    }

    public static ParsedDateRange fromXContent(XContentParser parser, String name) throws IOException {
        ParsedDateRange aggregation = PARSER.parse(parser, null);
        aggregation.setName(name);
        return aggregation;
    }

    static {
        ParsedDateRange.declareParsedRangeFields(PARSER, parser -> ParsedBucket.fromXContent(parser, false), parser -> ParsedBucket.fromXContent(parser, true));
    }

    public static class ParsedBucket
    extends ParsedRange.ParsedBucket {
        @Override
        public Object getFrom() {
            return ParsedBucket.doubleAsDateTime(this.from);
        }

        @Override
        public Object getTo() {
            return ParsedBucket.doubleAsDateTime(this.to);
        }

        private static DateTime doubleAsDateTime(Double d) {
            if (d == null || Double.isInfinite(d)) {
                return null;
            }
            return new DateTime(d.longValue(), DateTimeZone.UTC);
        }

        static ParsedBucket fromXContent(XContentParser parser, boolean keyed) throws IOException {
            return ParsedBucket.parseRangeBucketXContent(parser, ParsedBucket::new, keyed);
        }
    }
}

