/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.fetch;

import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.search.SearchPhaseResult;
import conductor.org.elasticsearch.search.SearchShardTarget;
import conductor.org.elasticsearch.search.fetch.FetchSearchResult;
import conductor.org.elasticsearch.search.query.QuerySearchResult;
import java.io.IOException;

public final class QueryFetchSearchResult
extends SearchPhaseResult {
    private QuerySearchResult queryResult;
    private FetchSearchResult fetchResult;

    public QueryFetchSearchResult() {
    }

    public QueryFetchSearchResult(QuerySearchResult queryResult, FetchSearchResult fetchResult) {
        this.queryResult = queryResult;
        this.fetchResult = fetchResult;
    }

    @Override
    public long getRequestId() {
        return this.queryResult.getRequestId();
    }

    @Override
    public SearchShardTarget getSearchShardTarget() {
        return this.queryResult.getSearchShardTarget();
    }

    @Override
    public void setSearchShardTarget(SearchShardTarget shardTarget) {
        super.setSearchShardTarget(shardTarget);
        this.queryResult.setSearchShardTarget(shardTarget);
        this.fetchResult.setSearchShardTarget(shardTarget);
    }

    @Override
    public void setShardIndex(int requestIndex) {
        super.setShardIndex(requestIndex);
        this.queryResult.setShardIndex(requestIndex);
        this.fetchResult.setShardIndex(requestIndex);
    }

    @Override
    public QuerySearchResult queryResult() {
        return this.queryResult;
    }

    @Override
    public FetchSearchResult fetchResult() {
        return this.fetchResult;
    }

    public static QueryFetchSearchResult readQueryFetchSearchResult(StreamInput in) throws IOException {
        QueryFetchSearchResult result = new QueryFetchSearchResult();
        result.readFrom(in);
        return result;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.queryResult = QuerySearchResult.readQuerySearchResult(in);
        this.fetchResult = FetchSearchResult.readFetchSearchResult(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.queryResult.writeTo(out);
        this.fetchResult.writeTo(out);
    }
}

