/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.fetch.subphase.highlight;

import conductor.org.apache.lucene.document.Field;
import conductor.org.apache.lucene.document.TextField;
import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.index.IndexableFieldType;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.search.highlight.Encoder;
import conductor.org.apache.lucene.search.vectorhighlight.BoundaryScanner;
import conductor.org.apache.lucene.search.vectorhighlight.FieldFragList;
import conductor.org.apache.lucene.search.vectorhighlight.ScoreOrderFragmentsBuilder;
import conductor.org.elasticsearch.index.mapper.MappedFieldType;
import conductor.org.elasticsearch.search.fetch.subphase.highlight.FragmentBuilderHelper;
import conductor.org.elasticsearch.search.internal.SearchContext;
import conductor.org.elasticsearch.search.lookup.SourceLookup;
import java.io.IOException;
import java.util.List;

public class SourceScoreOrderFragmentsBuilder
extends ScoreOrderFragmentsBuilder {
    private final MappedFieldType fieldType;
    private final SearchContext searchContext;

    public SourceScoreOrderFragmentsBuilder(MappedFieldType fieldType, SearchContext searchContext, String[] preTags, String[] postTags, BoundaryScanner boundaryScanner) {
        super(preTags, postTags, boundaryScanner);
        this.fieldType = fieldType;
        this.searchContext = searchContext;
    }

    @Override
    protected Field[] getFields(IndexReader reader, int docId, String fieldName) throws IOException {
        SourceLookup sourceLookup = this.searchContext.lookup().source();
        sourceLookup.setSegmentAndDocument((LeafReaderContext)reader.getContext(), docId);
        List<Object> values = sourceLookup.extractRawValues(this.fieldType.name());
        Field[] fields = new Field[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            fields[i] = new Field(this.fieldType.name(), values.get(i).toString(), (IndexableFieldType)TextField.TYPE_NOT_STORED);
        }
        return fields;
    }

    @Override
    protected String makeFragment(StringBuilder buffer, int[] index, Field[] values, FieldFragList.WeightedFragInfo fragInfo, String[] preTags, String[] postTags, Encoder encoder) {
        FieldFragList.WeightedFragInfo weightedFragInfo = FragmentBuilderHelper.fixWeightedFragInfo(this.fieldType, values, fragInfo);
        return super.makeFragment(buffer, index, values, weightedFragInfo, preTags, postTags, encoder);
    }
}

